/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.network;

import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6857;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.client.CollectorsAlbumClient;
import team.tnt.collectoralbum.network.api.IClientPacket;
import team.tnt.collectoralbum.network.api.IPacket;
import team.tnt.collectoralbum.network.api.IPacketDecoder;
import team.tnt.collectoralbum.network.api.IPacketEncoder;
import team.tnt.collectoralbum.network.api.IServerPacket;
import team.tnt.collectoralbum.network.packet.OpenCardScreenPacket;
import team.tnt.collectoralbum.network.packet.RequestAlbumPagePacket;
import team.tnt.collectoralbum.network.packet.RequestCardPackDropPacket;
import team.tnt.collectoralbum.network.packet.SendAlbumBoostsPacket;

public class Networking {
    public static <T> void dispatchServerPacket(IServerPacket<T> serverPacket) {
        Networking.dispatch(serverPacket, ClientPlayNetworking::send);
    }

    public static <T> void dispatchClientPacket(class_3222 serverPlayerRef, IClientPacket<T> clientPacket) {
        Networking.dispatch(clientPacket, (packetId, buffer) -> ServerPlayNetworking.send((class_3222)serverPlayerRef, (class_2960)packetId, (class_2540)buffer));
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientReceivers() {
        Networking.registerServer2ClientReceiver(OpenCardScreenPacket.class);
        Networking.registerServer2ClientReceiver(SendAlbumBoostsPacket.class);
    }

    public static void registerServerReceivers() {
        Networking.registerClient2ServerReceiver(RequestCardPackDropPacket.class);
        Networking.registerClient2ServerReceiver(RequestAlbumPagePacket.class);
    }

    public static class_2960 generateUniquePacketId(Class<? extends IPacket<?>> packetClass) {
        String packetClassName = packetClass.getSimpleName();
        return new class_2960("collectorsalbum", packetClassName.replaceAll("\\B([A-Z])", "_$1").toLowerCase());
    }

    private static <T> void dispatch(IPacket<T> packet, BiConsumer<class_2960, class_2540> dispatcher) {
        class_2960 packetId = packet.getPacketId();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        IPacketEncoder<T> encoder = packet.getEncoder();
        T data = packet.getPacketData();
        encoder.encode(data, buffer);
        dispatcher.accept(packetId, buffer);
    }

    @Environment(value=EnvType.CLIENT)
    private static <T> void registerServer2ClientReceiver(Class<? extends IClientPacket<T>> clientPacketClass) {
        try {
            IClientPacket packet = clientPacketClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            class_2960 packetId = packet.getPacketId();
            ClientPlayNetworking.registerGlobalReceiver((class_2960)packetId, (client, handler, buffer, responseDispatcher) -> {
                IPacketDecoder decoder = packet.getDecoder();
                Object packetData = decoder.decode(buffer);
                client.execute(() -> packet.handleClientsidePacket(client, handler, packetData, responseDispatcher));
            });
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exc) {
            CollectorsAlbumClient.LOGGER.fatal("Couldn't instantiate new client packet from class {}, make sure it declares public default constructor", (Object)clientPacketClass.getSimpleName());
            throw new RuntimeException(exc);
        }
    }

    private static <T> void registerClient2ServerReceiver(Class<? extends IServerPacket<T>> serverPacketClass) {
        try {
            IServerPacket packet = serverPacketClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            class_2960 packetId = packet.getPacketId();
            ServerPlayNetworking.registerGlobalReceiver((class_2960)packetId, (server, player, handler, buffer, responseDispatcher) -> {
                IPacketDecoder decoder = packet.getDecoder();
                Object packetData = decoder.decode(buffer);
                server.execute(() -> packet.handleServersidePacket(server, player, (class_6857)handler, packetData, responseDispatcher));
            });
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exc) {
            CollectorsAlbum.LOGGER.fatal("Couldn't instantiate new server packet from class {}, make sure it declares public default constructor", (Object)serverPacketClass.getSimpleName());
            throw new RuntimeException(exc);
        }
    }
}

