/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.network.packet;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5244;
import net.minecraft.class_6857;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.container.AlbumContainer;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.init.ItemRegistry;
import team.tnt.collectoralbum.common.menu.AlbumMenu;
import team.tnt.collectoralbum.network.Networking;
import team.tnt.collectoralbum.network.api.IPacketDecoder;
import team.tnt.collectoralbum.network.api.IPacketEncoder;
import team.tnt.collectoralbum.network.api.IServerPacket;

public class RequestAlbumPagePacket
implements IServerPacket<AlbumPacketData> {
    private static final class_2960 PACKET_ID = Networking.generateUniquePacketId(RequestAlbumPagePacket.class);
    private final AlbumPacketData data;

    public RequestAlbumPagePacket() {
        this(null);
    }

    public RequestAlbumPagePacket(ICardCategory category) {
        this.data = new AlbumPacketData(category);
    }

    @Override
    public class_2960 getPacketId() {
        return PACKET_ID;
    }

    @Override
    public AlbumPacketData getPacketData() {
        return this.data;
    }

    @Override
    public IPacketEncoder<AlbumPacketData> getEncoder() {
        return (packetData, buffer) -> {
            ICardCategory category = packetData.category;
            buffer.writeBoolean(category != null);
            if (category != null) {
                buffer.method_10812(category.getId());
            }
        };
    }

    @Override
    public IPacketDecoder<AlbumPacketData> getDecoder() {
        return buffer -> {
            boolean flag = buffer.readBoolean();
            ICardCategory category = null;
            if (flag) {
                category = CardCategoryRegistry.getByKey(buffer.method_10810());
            }
            return new AlbumPacketData(category);
        };
    }

    @Override
    public void handleServersidePacket(MinecraftServer server, class_3222 player, class_6857 listener, final AlbumPacketData packetData, PacketSender dispatcher) {
        final class_1799 stack = player.method_6047();
        if (stack.method_7909() != ItemRegistry.ALBUM) {
            return;
        }
        final AlbumContainer container = new AlbumContainer(stack);
        final ICardCategory category = packetData.category;
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.method_10793(stack);
                buf.writeBoolean(category != null);
                if (category != null) {
                    buf.method_10812(category.getId());
                }
            }

            public class_2561 method_5476() {
                return class_5244.field_39003;
            }

            @Nullable
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                return new AlbumMenu(container, inventory, i, packetData.category);
            }
        });
    }

    static class AlbumPacketData {
        private final ICardCategory category;

        AlbumPacketData(ICardCategory category) {
            this.category = category;
        }
    }
}

