/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.util.math;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class WeightedRandom<T>
implements Supplier<T> {
    private final Random random;
    private final T[] weightedEntries;
    private final ToIntFunction<T> weightProvider;
    private final int computedTotal;

    private WeightedRandom(Random random, T[] weightedEntries, ToIntFunction<T> weightProvider) {
        this.random = random;
        this.weightedEntries = weightedEntries;
        this.weightProvider = weightProvider;
        this.computedTotal = this.computeTotal();
        if (weightedEntries == null || weightedEntries.length == 0 || this.computedTotal < 1) {
            throw new IllegalArgumentException("Weighted random must contain atleast one entry with weight value over 0");
        }
    }

    public static <T> WeightedRandom<T> createWithSeed(long seed, T[] weightedEntries, ToIntFunction<T> weightProvider) {
        Random rng = new Random(seed);
        return new WeightedRandom<T>(rng, weightedEntries, weightProvider);
    }

    public static <T extends IWeighted> WeightedRandom<T> createWithSeed(long seed, T[] entries) {
        return WeightedRandom.createWithSeed(seed, entries, IWeighted::getWeight);
    }

    public static <T> WeightedRandom<T> create(T[] weightedEntries, ToIntFunction<T> weightProvider) {
        Random rng = new Random();
        return new WeightedRandom<T>(rng, weightedEntries, weightProvider);
    }

    public static <T extends IWeighted> WeightedRandom<T> create(T[] entries) {
        return WeightedRandom.create(entries, IWeighted::getWeight);
    }

    @Override
    public T get() {
        int buffer = this.random.nextInt(this.computedTotal);
        for (int i = this.weightedEntries.length - 1; i >= 0; --i) {
            T value = this.weightedEntries[i];
            if ((buffer -= this.weightProvider.applyAsInt(value)) >= 0) continue;
            return value;
        }
        throw new IllegalStateException("Weighted value couldn't be selected for unknown reason");
    }

    private int computeTotal() {
        return Arrays.stream(this.weightedEntries).mapToInt(this.weightProvider).reduce(Integer::sum).orElse(1);
    }

    public static class Builder<T> {
        private Supplier<Random> rngSupplier = Random::new;
        private ToIntFunction<T> provider;
        private final List<T> entries = new ArrayList<T>();

        private Builder() {
        }

        public static <T> Builder<T> create() {
            return new Builder<T>();
        }

        public Builder<T> rng(Supplier<Random> supplier) {
            this.rngSupplier = supplier;
            return this;
        }

        public Builder<T> withSeed(long seed) {
            return this.rng(() -> new Random(seed));
        }

        public Builder<T> provider(ToIntFunction<T> provider) {
            this.provider = provider;
            return this;
        }

        public Builder<T> append(T value) {
            this.entries.add(value);
            return this;
        }

        public WeightedRandom<T> build(Function<Integer, T[]> arrayFactory) {
            Preconditions.checkNotNull(this.rngSupplier);
            Preconditions.checkNotNull(this.provider);
            Preconditions.checkState((!this.entries.isEmpty() ? 1 : 0) != 0);
            return new WeightedRandom<T>(this.rngSupplier.get(), this.entries.toArray(arrayFactory.apply(0)), this.provider);
        }
    }

    @FunctionalInterface
    public static interface IWeighted
    extends Supplier<Integer> {
        public int getWeight();

        @Override
        default public Integer get() {
            return this.getWeight();
        }
    }
}

