/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch;

import com.javic.slimpatch.ModEntities;
import com.javic.slimpatch.client.gui.SkinSelectionHandler;
import com.javic.slimpatch.client.model.CustomVillagerModelMale;
import com.javic.slimpatch.client.model.FemaleVillagerModel;
import com.javic.slimpatch.client.model.HumanEvokerModelFemale;
import com.javic.slimpatch.client.model.HumanEvokerModelMale;
import com.javic.slimpatch.client.model.HumanPillagerModelFemale;
import com.javic.slimpatch.client.model.HumanPillagerModelMale;
import com.javic.slimpatch.client.model.HumanVindicatorModelFemale;
import com.javic.slimpatch.client.model.HumanVindicatorModelMale;
import com.javic.slimpatch.client.model.HumanWanderingTraderModelFemale;
import com.javic.slimpatch.client.model.HumanWanderingTraderModelMale;
import com.javic.slimpatch.client.renderer.FemaleVillagerRenderer;
import com.javic.slimpatch.client.renderer.HumanEvokerRenderer;
import com.javic.slimpatch.client.renderer.HumanPillagerRenderer;
import com.javic.slimpatch.client.renderer.HumanVindicatorRenderer;
import com.javic.slimpatch.client.renderer.HumanWanderingTraderRenderer;
import com.javic.slimpatch.client.renderer.HumanWitchRenderer;
import com.javic.slimpatch.client.renderer.MaleVillagerRenderer;
import com.javic.slimpatch.commands.SpawnHumanTraderCommand;
import com.javic.slimpatch.commands.TestIllagerSoundCommand;
import com.javic.slimpatch.commands.TestSoundCommand;
import com.javic.slimpatch.entity.HumanEvokerEntity;
import com.javic.slimpatch.entity.HumanPillagerEntity;
import com.javic.slimpatch.entity.HumanVindicatorEntity;
import com.javic.slimpatch.entity.HumanWanderingTraderEntity;
import com.javic.slimpatch.item.ModItems;
import com.javic.slimpatch.network.LoginHandler;
import com.javic.slimpatch.network.ModNetworking;
import com.javic.slimpatch.network.ServerCooldownTracker;
import com.javic.slimpatch.sounds.HumanIllagerSounds;
import com.javic.slimpatch.sounds.HumanVillagerSounds;
import com.mojang.logging.LogUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.slf4j.Logger;

@Mod(value="slimpatch")
public class SlimPatch {
    public static final String MODID = "slimpatch";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SlimPatch(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("SlimPatch inicializado correctamente.");
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        HumanVillagerSounds.register(modEventBus);
        HumanIllagerSounds.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(TestSoundCommand::register);
        NeoForge.EVENT_BUS.addListener(TestIllagerSoundCommand::register);
        NeoForge.EVENT_BUS.addListener(SpawnHumanTraderCommand::register);
        modEventBus.addListener(this::registerRenderers);
        modEventBus.addListener(this::registerLayerDefinitions);
        modEventBus.addListener(this::addItemsToCreativeTabs);
        modEventBus.addListener(this::registerAttributes);
        modEventBus.addListener(this::registerItemColors);
        NeoForge.EVENT_BUS.addListener(this::replaceVanillaEntities);
        ModNetworking.register(modEventBus);
        LoginHandler.register();
        NeoForge.EVENT_BUS.register(SkinSelectionHandler.class);
        ServerCooldownTracker.init();
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("[SlimPatch] Common setup ejecutado correctamente.");
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntities.MALE_VILLAGER.get(), MaleVillagerRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FEMALE_VILLAGER.get(), FemaleVillagerRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HUMAN_WANDERING_TRADER.get(), HumanWanderingTraderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HUMAN_PILLAGER.get(), HumanPillagerRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HUMAN_VINDICATOR.get(), HumanVindicatorRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HUMAN_EVOKER.get(), HumanEvokerRenderer::new);
        event.registerEntityRenderer(EntityType.WITCH, HumanWitchRenderer::new);
    }

    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FemaleVillagerModel.LAYER_LOCATION, FemaleVillagerModel::createBodyLayer);
        event.registerLayerDefinition(CustomVillagerModelMale.LAYER_LOCATION, CustomVillagerModelMale::createBodyLayer);
        event.registerLayerDefinition(HumanPillagerModelMale.LAYER_LOCATION, HumanPillagerModelMale::createBodyLayer);
        event.registerLayerDefinition(HumanPillagerModelFemale.LAYER_LOCATION, HumanPillagerModelFemale::createBodyLayer);
        event.registerLayerDefinition(HumanVindicatorModelMale.LAYER_LOCATION, HumanVindicatorModelMale::createBodyLayer);
        event.registerLayerDefinition(HumanVindicatorModelFemale.LAYER_LOCATION, HumanVindicatorModelFemale::createBodyLayer);
        event.registerLayerDefinition(HumanEvokerModelMale.LAYER_LOCATION, HumanEvokerModelMale::createBodyLayer);
        event.registerLayerDefinition(HumanEvokerModelFemale.LAYER_LOCATION, HumanEvokerModelFemale::createBodyLayer);
        event.registerLayerDefinition(HumanWanderingTraderModelMale.LAYER_LOCATION, HumanWanderingTraderModelMale::createBodyLayer);
        event.registerLayerDefinition(HumanWanderingTraderModelFemale.LAYER_LOCATION, HumanWanderingTraderModelFemale::createBodyLayer);
    }

    private void addItemsToCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)ModItems.MALE_VILLAGER_SPAWN_EGG.get());
            event.accept((ItemLike)ModItems.FEMALE_VILLAGER_SPAWN_EGG.get());
        }
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        AttributeSupplier villagerAttributes = Villager.createAttributes().build();
        event.put((EntityType)ModEntities.MALE_VILLAGER.get(), villagerAttributes);
        event.put((EntityType)ModEntities.FEMALE_VILLAGER.get(), villagerAttributes);
        event.put((EntityType)ModEntities.HUMAN_WANDERING_TRADER.get(), villagerAttributes);
        AttributeSupplier illagerAttributes = Pillager.createAttributes().build();
        event.put((EntityType)ModEntities.HUMAN_PILLAGER.get(), illagerAttributes);
        event.put((EntityType)ModEntities.HUMAN_VINDICATOR.get(), illagerAttributes);
        event.put((EntityType)ModEntities.HUMAN_EVOKER.get(), illagerAttributes);
        LOGGER.info("[SlimPatch] Atributos registrados para Male, Female, Trader y Human Illagers.");
    }

    private void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, layer) -> -1, new ItemLike[]{(ItemLike)ModItems.MALE_VILLAGER_SPAWN_EGG.get()});
        event.register((stack, layer) -> -1, new ItemLike[]{(ItemLike)ModItems.FEMALE_VILLAGER_SPAWN_EGG.get()});
        LOGGER.info("[SlimPatch] Colores de spawn eggs deshabilitados (usando texturas personalizadas).");
    }

    private void replaceVanillaEntities(EntityJoinLevelEvent event) {
        Entity data;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Villager) {
            Villager vanilla = (Villager)entity;
            data = vanilla.getPersistentData();
            if (data.getBoolean("slimpatch_replaced") || data.getBoolean("slimpatch_forced")) {
                return;
            }
            Level level = event.getLevel();
            boolean spawnMale = level.getRandom().nextBoolean();
            EntityType entityType = spawnMale ? (EntityType)ModEntities.MALE_VILLAGER.get() : (EntityType)ModEntities.FEMALE_VILLAGER.get();
            Villager newVillager = (Villager)entityType.create(level);
            if (newVillager != null) {
                event.setCanceled(true);
                newVillager.moveTo(vanilla.getX(), vanilla.getY(), vanilla.getZ(), vanilla.getYRot(), vanilla.getXRot());
                newVillager.getPersistentData().putBoolean("slimpatch_replaced", true);
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                    newVillager.finalizeSpawn(serverLevel, level.getCurrentDifficultyAt(vanilla.blockPosition()), MobSpawnType.NATURAL, null);
                }
                level.addFreshEntity((Entity)newVillager);
                LOGGER.info("[SlimPatch] Reemplazado aldeano vanilla por {} en {}", (Object)(spawnMale ? "male" : "female"), (Object)level.dimension().location());
            }
            return;
        }
        data = event.getEntity();
        if (data instanceof WanderingTrader) {
            WanderingTrader vanillaTrader = (WanderingTrader)data;
            if ((data = vanillaTrader.getPersistentData()).getBoolean("slimpatch_replaced") || data.getBoolean("slimpatch_forced")) {
                return;
            }
            Level level = event.getLevel();
            EntityType humanType = (EntityType)ModEntities.HUMAN_WANDERING_TRADER.get();
            HumanWanderingTraderEntity newTrader = (HumanWanderingTraderEntity)humanType.create(level);
            if (newTrader != null) {
                event.setCanceled(true);
                newTrader.moveTo(vanillaTrader.getX(), vanillaTrader.getY(), vanillaTrader.getZ(), vanillaTrader.getYRot(), vanillaTrader.getXRot());
                newTrader.getPersistentData().putBoolean("slimpatch_replaced", true);
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                    newTrader.finalizeSpawn(serverLevel, level.getCurrentDifficultyAt(vanillaTrader.blockPosition()), MobSpawnType.NATURAL, null);
                }
                level.addFreshEntity((Entity)newTrader);
                vanillaTrader.discard();
                LOGGER.info("[SlimPatch] Reemplazado Wandering Trader vanilla por versi\u00f3n humana en {}", (Object)level.dimension().location());
            }
            return;
        }
        data = event.getEntity();
        if (data instanceof Pillager) {
            Pillager vanillaPillager = (Pillager)data;
            if ((data = vanillaPillager.getPersistentData()).getBoolean("slimpatch_replaced") || data.getBoolean("slimpatch_forced")) {
                return;
            }
            Level level = event.getLevel();
            EntityType humanType = (EntityType)ModEntities.HUMAN_PILLAGER.get();
            HumanPillagerEntity newPillager = (HumanPillagerEntity)humanType.create(level);
            if (newPillager != null) {
                event.setCanceled(true);
                newPillager.moveTo(vanillaPillager.getX(), vanillaPillager.getY(), vanillaPillager.getZ(), vanillaPillager.getYRot(), vanillaPillager.getXRot());
                newPillager.getPersistentData().putBoolean("slimpatch_replaced", true);
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                    newPillager.finalizeSpawn(serverLevel, level.getCurrentDifficultyAt(vanillaPillager.blockPosition()), MobSpawnType.NATURAL, null);
                }
                level.addFreshEntity((Entity)newPillager);
                LOGGER.info("[SlimPatch] Reemplazado Pillager vanilla por versi\u00f3n humana en {}", (Object)level.dimension().location());
            }
            return;
        }
        data = event.getEntity();
        if (data instanceof Evoker) {
            Evoker vanillaEvoker = (Evoker)data;
            if ((data = vanillaEvoker.getPersistentData()).getBoolean("slimpatch_replaced") || data.getBoolean("slimpatch_forced")) {
                return;
            }
            Level level = event.getLevel();
            EntityType humanType = (EntityType)ModEntities.HUMAN_EVOKER.get();
            HumanEvokerEntity newEvoker = (HumanEvokerEntity)humanType.create(level);
            if (newEvoker != null) {
                event.setCanceled(true);
                newEvoker.moveTo(vanillaEvoker.getX(), vanillaEvoker.getY(), vanillaEvoker.getZ(), vanillaEvoker.getYRot(), vanillaEvoker.getXRot());
                newEvoker.getPersistentData().putBoolean("slimpatch_replaced", true);
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                    newEvoker.finalizeSpawn(serverLevel, level.getCurrentDifficultyAt(vanillaEvoker.blockPosition()), MobSpawnType.NATURAL, null);
                }
                level.addFreshEntity((Entity)newEvoker);
                LOGGER.info("[SlimPatch] Reemplazado Evoker vanilla por versi\u00f3n humana en {}", (Object)level.dimension().location());
            }
            return;
        }
        data = event.getEntity();
        if (data instanceof Vindicator) {
            Vindicator vanillaVindicator = (Vindicator)data;
            if ((data = vanillaVindicator.getPersistentData()).getBoolean("slimpatch_replaced") || data.getBoolean("slimpatch_forced")) {
                return;
            }
            Level level = event.getLevel();
            EntityType humanType = (EntityType)ModEntities.HUMAN_VINDICATOR.get();
            HumanVindicatorEntity newVindicator = (HumanVindicatorEntity)humanType.create(level);
            if (newVindicator != null) {
                event.setCanceled(true);
                newVindicator.moveTo(vanillaVindicator.getX(), vanillaVindicator.getY(), vanillaVindicator.getZ(), vanillaVindicator.getYRot(), vanillaVindicator.getXRot());
                newVindicator.getPersistentData().putBoolean("slimpatch_replaced", true);
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                    newVindicator.finalizeSpawn(serverLevel, level.getCurrentDifficultyAt(vanillaVindicator.blockPosition()), MobSpawnType.NATURAL, null);
                }
                level.addFreshEntity((Entity)newVindicator);
                LOGGER.info("[SlimPatch] Reemplazado Vindicator vanilla por versi\u00f3n humana en {}", (Object)level.dimension().location());
            }
        }
    }
}

