/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.gui;

import com.javic.slimpatch.client.ClientSkinTheme;
import com.javic.slimpatch.client.gui.SkinSelectionScreen;
import com.javic.slimpatch.data.WorldSkinData;
import com.javic.slimpatch.network.VillagerCooldownsStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public class SkinSelectionHandler {
    private static boolean checked = false;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (!checked && mc.player != null && mc.level != null) {
            ServerLevel serverLevel;
            checked = true;
            String theme = null;
            if (mc.getSingleplayerServer() != null && (serverLevel = mc.getSingleplayerServer().overworld()) != null) {
                theme = WorldSkinData.get(serverLevel).getTheme();
            }
            if (theme == null || theme.isEmpty()) {
                mc.setScreen((Screen)new SkinSelectionScreen());
            } else {
                ClientSkinTheme.setTheme(theme);
            }
        }
    }

    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        checked = false;
        ClientSkinTheme.setTheme("");
        VillagerCooldownsStorage.clear();
    }
}

