/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.gui;

import com.javic.slimpatch.client.ClientSkinTheme;
import com.javic.slimpatch.data.WorldSkinData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class SkinSelectionScreen
extends Screen {
    public SkinSelectionScreen() {
        super((Component)Component.literal((String)"Villager Skin Selection"));
    }

    protected void init() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Modern"), btn -> this.chooseTheme("modern")).pos(centerX - 100, centerY).size(90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Fantasy"), btn -> this.chooseTheme("fantasy")).pos(centerX + 10, centerY).size(90, 20).build());
    }

    private void chooseTheme(String theme) {
        ServerLevel serverLevel;
        ClientSkinTheme.setTheme(theme);
        if (Minecraft.getInstance().getSingleplayerServer() != null && (serverLevel = Minecraft.getInstance().getSingleplayerServer().overworld()) != null) {
            WorldSkinData.get(serverLevel).setTheme(theme);
        }
        this.onClose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().pushPose();
        graphics.pose().scale(1.7f, 1.7f, 1.7f);
        int scaledX = (int)((float)(this.width / 2) / 1.7f);
        int scaledY = (int)((float)(this.height / 2 - 100) / 1.7f);
        graphics.drawCenteredString(this.font, "Select Villager Skins", scaledX, scaledY, 0xFFFF55);
        graphics.pose().popPose();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void onClose() {
        String theme = ClientSkinTheme.getTheme();
        if (theme != null && !theme.isEmpty()) {
            super.onClose();
        }
    }
}

