/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.gui;

import com.javic.slimpatch.client.gui.VillagerPersonalityIcons;
import com.javic.slimpatch.client.gui.VillagerProfessionIcons;
import com.javic.slimpatch.dialogue.DialogueManager;
import com.javic.slimpatch.entity.FemaleVillagerEntity;
import com.javic.slimpatch.entity.MaleVillagerEntity;
import com.javic.slimpatch.entity.VillagerPersonality;
import com.javic.slimpatch.network.RelationshipPacket;
import com.javic.slimpatch.network.VillagerCooldownsStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.neoforged.neoforge.network.PacketDistributor;

public class VillagerDialogueScreen
extends Screen {
    private final Villager villager;
    private final int optionWidth = 200;
    private final int optionHeight = 16;
    private final int optionSpacing = 4;
    private String fullLine = "";
    private int visibleChars = 0;
    private long lastCharTime = 0L;
    private static final int CHAR_INTERVAL_MS = 30;
    private static final ResourceLocation HEART_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"slimpatch", (String)"textures/gui/heart_empty.png");
    private static final ResourceLocation HEART_HALF = ResourceLocation.fromNamespaceAndPath((String)"slimpatch", (String)"textures/gui/heart_half.png");
    private static final ResourceLocation HEART_FULL = ResourceLocation.fromNamespaceAndPath((String)"slimpatch", (String)"textures/gui/heart_full.png");
    private static final int HEART_SIZE = 16;

    public VillagerDialogueScreen(Villager villager) {
        super((Component)Component.literal((String)"Dialogue"));
        this.villager = villager;
    }

    protected void init() {
        super.init();
        this.fullLine = DialogueManager.getRandomLine("Intro", this.villager);
        this.visibleChars = 0;
        this.lastCharTime = System.currentTimeMillis();
        UUID uuid = this.villager.getUUID();
        Map<String, Integer> existing = VillagerCooldownsStorage.getCooldowns(uuid);
        if (existing.isEmpty()) {
            HashMap<String, Integer> initial = new HashMap<String, Integer>();
            initial.put("Friendly", 0);
            initial.put("Mean", 0);
            initial.put("Joke", 0);
            initial.put("Flirt", 0);
            VillagerCooldownsStorage.setCooldowns(uuid, initial);
        }
        int totalHeight = 80;
        int startY = this.height - totalHeight - 40;
        int centerX = this.width / 2 - 100;
        this.addRenderableWidget((GuiEventListener)new DialogueOption(centerX, startY, "Friendly"));
        this.addRenderableWidget((GuiEventListener)new DialogueOption(centerX, startY + 20, "Mean"));
        this.addRenderableWidget((GuiEventListener)new DialogueOption(centerX, startY + 40, "Joke"));
        this.addRenderableWidget((GuiEventListener)new DialogueOption(centerX, startY + 60, "Flirt"));
    }

    private void onOptionClicked(String option) {
        VillagerPersonality personality = null;
        Villager villager = this.villager;
        if (villager instanceof MaleVillagerEntity) {
            MaleVillagerEntity male = (MaleVillagerEntity)villager;
            personality = male.getPersonality();
        } else {
            villager = this.villager;
            if (villager instanceof FemaleVillagerEntity) {
                FemaleVillagerEntity female = (FemaleVillagerEntity)villager;
                personality = female.getPersonality();
            }
        }
        boolean success = DialogueManager.calculateSuccess(personality, option);
        this.fullLine = DialogueManager.getRandomLine(option, this.villager, success);
        this.visibleChars = 0;
        this.lastCharTime = System.currentTimeMillis();
        if (this.minecraft != null && this.minecraft.player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RelationshipPacket(this.villager.getId(), option, success), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, this.height - 150, this.width, this.height, -2013265920);
        super.render(graphics, mouseX, mouseY, partialTicks);
        int heartX = 8;
        int topY = 10;
        float relationship = 0.0f;
        Villager villager = this.villager;
        if (villager instanceof MaleVillagerEntity) {
            MaleVillagerEntity male = (MaleVillagerEntity)villager;
            relationship = male.getRelationship();
        } else {
            villager = this.villager;
            if (villager instanceof FemaleVillagerEntity) {
                FemaleVillagerEntity female = (FemaleVillagerEntity)villager;
                relationship = female.getRelationship();
            }
        }
        for (int i = 0; i < 5; ++i) {
            int x = heartX + i * 18;
            if (i + 1 <= (int)relationship) {
                graphics.blit(HEART_FULL, x, topY, 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            if ((double)i + 0.5 <= (double)relationship) {
                graphics.blit(HEART_HALF, x, topY, 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            graphics.blit(HEART_EMPTY, x, topY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        int leftX = 10;
        int textY = topY + 16 + 8;
        String villagerName = this.villager.hasCustomName() ? this.villager.getCustomName().getString() : this.villager.getName().getString();
        this.drawTextWithIcon(graphics, villagerName, leftX, textY, 0xFFFFFF, null, mouseX, mouseY, null);
        int nameWidth = this.font.width(villagerName);
        int nameX1 = leftX;
        int nameX2 = leftX + nameWidth;
        int nameY1 = textY;
        Objects.requireNonNull(this.font);
        int nameY2 = nameY1 + 9;
        if (mouseX >= nameX1 && mouseX <= nameX2 && mouseY >= nameY1 && mouseY <= nameY2) {
            String gender = this.villager instanceof MaleVillagerEntity ? "Male" : (this.villager instanceof FemaleVillagerEntity ? "Female" : "Unknown");
            graphics.renderTooltip(this.font, (Component)Component.literal((String)gender), mouseX, mouseY);
        }
        textY += 20;
        VillagerPersonality personality = null;
        Villager villager2 = this.villager;
        if (villager2 instanceof MaleVillagerEntity) {
            MaleVillagerEntity male = (MaleVillagerEntity)villager2;
            personality = male.getPersonality();
        } else {
            villager2 = this.villager;
            if (villager2 instanceof FemaleVillagerEntity) {
                FemaleVillagerEntity female = (FemaleVillagerEntity)villager2;
                personality = female.getPersonality();
            }
        }
        if (personality != null) {
            String personalityName = VillagerPersonalityIcons.getName(personality);
            ResourceLocation personalityIcon = VillagerPersonalityIcons.getIcon(personality);
            this.drawTextWithIcon(graphics, personalityName, leftX, textY, 0xFFFFFF, "Personality", mouseX, mouseY, personalityIcon);
        } else {
            this.drawTextWithIcon(graphics, "DEBUG_NULL", leftX, textY, 0xFF0000, "Personality", mouseX, mouseY, null);
        }
        VillagerProfession profession = this.villager.getVillagerData().getProfession();
        String professionName = VillagerProfessionIcons.getName(profession);
        ResourceLocation professionIcon = VillagerProfessionIcons.getIcon(profession);
        this.drawTextWithIcon(graphics, professionName, leftX, textY += 20, 0xFFFFFF, "Job", mouseX, mouseY, professionIcon);
        long now = System.currentTimeMillis();
        if (this.visibleChars < this.fullLine.length() && now - this.lastCharTime > 30L) {
            ++this.visibleChars;
            this.lastCharTime = now;
        }
        String visibleText = this.fullLine.substring(0, Math.min(this.visibleChars, this.fullLine.length()));
        String villagerLine = villagerName + ": " + visibleText;
        this.drawCenteredBorderedString(graphics, villagerLine, this.width / 2, this.height - 165, 16775395);
        int totalHeartWidth = 90;
        if (mouseX >= heartX && mouseX <= heartX + totalHeartWidth && mouseY >= topY && mouseY <= topY + 16) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)"Relationship"), mouseX, mouseY);
        }
    }

    private void drawTextWithIcon(GuiGraphics graphics, String text, int x, int y, int color, String hover, int mouseX, int mouseY, ResourceLocation icon) {
        int textStartX = x;
        graphics.drawString(this.font, text, textStartX + 1, y, 0);
        graphics.drawString(this.font, text, textStartX - 1, y, 0);
        graphics.drawString(this.font, text, textStartX, y + 1, 0);
        graphics.drawString(this.font, text, textStartX, y - 1, 0);
        graphics.drawString(this.font, text, textStartX, y, color);
        int textWidth = this.font.width(text);
        int hoverX1 = textStartX;
        int hoverX2 = textStartX + textWidth;
        int hoverY1 = y;
        Objects.requireNonNull(this.font);
        int hoverY2 = y + 9;
        if (icon != null) {
            int iconX = textStartX + textWidth + 3;
            Objects.requireNonNull(this.font);
            int iconY = y + (9 - 15) / 2;
            graphics.blit(icon, iconX, iconY, 0.0f, 0.0f, 15, 15, 15, 15);
            hoverX2 = iconX + 15;
            hoverY1 = Math.min(hoverY1, iconY);
            hoverY2 = Math.max(hoverY2, iconY + 15);
        }
        if (hover != null && mouseX >= hoverX1 && mouseX <= hoverX2 && mouseY >= hoverY1 && mouseY <= hoverY2) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)hover), mouseX, mouseY);
        }
    }

    private void drawCenteredBorderedString(GuiGraphics graphics, String text, int x, int y, int color) {
        int shadow = 0;
        graphics.drawCenteredString(this.font, text, x + 1, y, shadow);
        graphics.drawCenteredString(this.font, text, x - 1, y, shadow);
        graphics.drawCenteredString(this.font, text, x, y + 1, shadow);
        graphics.drawCenteredString(this.font, text, x, y - 1, shadow);
        graphics.drawCenteredString(this.font, text, x, y, color);
    }

    public void onClose() {
        super.onClose();
        if (this.villager != null) {
            DialogueManager.endDialogue(this.villager);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private class DialogueOption
    extends Button {
        private final String option;

        public DialogueOption(int x, int y, String option) {
            super(x, y, 200, 16, (Component)Component.literal((String)option), b -> {}, DEFAULT_NARRATION);
            this.option = option;
        }

        public void onPress() {
            UUID uuid = VillagerDialogueScreen.this.villager.getUUID();
            Map<String, Integer> cooldowns = VillagerCooldownsStorage.getCooldowns(uuid);
            int remaining = cooldowns.getOrDefault(this.option, 0);
            if (remaining > 0) {
                return;
            }
            VillagerDialogueScreen.this.onOptionClicked(this.option);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            boolean onCooldown;
            UUID uuid = VillagerDialogueScreen.this.villager.getUUID();
            Map<String, Integer> cooldowns = VillagerCooldownsStorage.getCooldowns(uuid);
            int remaining = cooldowns.getOrDefault(this.option, 0);
            boolean bl = onCooldown = remaining > 0;
            int color = onCooldown ? 0x55333333 : (this.isHovered ? -1438366652 : -2013265920);
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, color);
            graphics.drawCenteredString(VillagerDialogueScreen.this.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, 0xFFFFFF);
            if (onCooldown && mouseX >= this.getX() && mouseX <= this.getX() + this.width && mouseY >= this.getY() && mouseY <= this.getY() + this.height) {
                graphics.renderTooltip(VillagerDialogueScreen.this.font, (Component)Component.literal((String)(remaining + "s")), mouseX, mouseY);
            }
        }
    }
}

