/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.key;

import com.javic.slimpatch.client.gui.VillagerDialogueScreen;
import com.javic.slimpatch.dialogue.DialogueManager;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(modid="slimpatch", value={Dist.CLIENT})
public class ModKeyBindings {
    public static KeyMapping OPEN_DIALOGUE;

    @SubscribeEvent
    public static void onRegisterKeys(RegisterKeyMappingsEvent event) {
        OPEN_DIALOGUE = new KeyMapping("key.slimpatch.open_dialogue", InputConstants.Type.KEYSYM, 82, "key.categories.slimpatch");
        event.register(OPEN_DIALOGUE);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (OPEN_DIALOGUE.consumeClick()) {
            Entity entity;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player != null && mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)mc.hitResult).getEntity()) instanceof Villager) {
                Villager villager = (Villager)entity;
                DialogueManager.startDialogue(villager, (Player)player);
                mc.setScreen((Screen)new VillagerDialogueScreen(villager));
            }
        }
    }
}

