/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.renderer;

import com.javic.slimpatch.client.model.HumanEvokerModelFemale;
import com.javic.slimpatch.client.model.HumanEvokerModelMale;
import com.javic.slimpatch.entity.HumanEvokerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class HumanEvokerRenderer
extends MobRenderer<HumanEvokerEntity, HumanoidModel<HumanEvokerEntity>> {
    private final HumanoidModel<HumanEvokerEntity> maleModel;
    private final HumanoidModel<HumanEvokerEntity> femaleModel;

    public HumanEvokerRenderer(EntityRendererProvider.Context context) {
        super(context, new HumanEvokerModelMale(context.bakeLayer(HumanEvokerModelMale.LAYER_LOCATION)), 0.5f);
        this.maleModel = new HumanEvokerModelMale<HumanEvokerEntity>(context.bakeLayer(HumanEvokerModelMale.LAYER_LOCATION));
        this.femaleModel = new HumanEvokerModelFemale<HumanEvokerEntity>(context.bakeLayer(HumanEvokerModelFemale.LAYER_LOCATION));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(HumanEvokerEntity entity) {
        return entity.getSkinTexture();
    }

    public void render(HumanEvokerEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.model = entity.isFemale() ? this.femaleModel : this.maleModel;
        poseStack.pushPose();
        poseStack.scale(entity.isFemale() ? 0.95f : 1.0f, entity.isFemale() ? 0.95f : 1.0f, entity.isFemale() ? 0.95f : 1.0f);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

