/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.renderer;

import com.javic.slimpatch.client.model.HumanPillagerModelFemale;
import com.javic.slimpatch.client.model.HumanPillagerModelMale;
import com.javic.slimpatch.entity.HumanPillagerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class HumanPillagerRenderer
extends MobRenderer<HumanPillagerEntity, HumanoidModel<HumanPillagerEntity>> {
    private final HumanoidModel<HumanPillagerEntity> maleModel;
    private final HumanoidModel<HumanPillagerEntity> femaleModel;

    public HumanPillagerRenderer(EntityRendererProvider.Context context) {
        super(context, new HumanPillagerModelMale(context.bakeLayer(HumanPillagerModelMale.LAYER_LOCATION)), 0.5f);
        this.maleModel = new HumanPillagerModelMale<HumanPillagerEntity>(context.bakeLayer(HumanPillagerModelMale.LAYER_LOCATION));
        this.femaleModel = new HumanPillagerModelFemale<HumanPillagerEntity>(context.bakeLayer(HumanPillagerModelFemale.LAYER_LOCATION));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(HumanPillagerEntity entity) {
        return entity.getSkinTexture();
    }

    public void render(HumanPillagerEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.model = entity.isFemale() ? this.femaleModel : this.maleModel;
        poseStack.pushPose();
        if (entity.isFemale()) {
            poseStack.scale(0.95f, 0.95f, 0.95f);
        } else {
            poseStack.scale(1.0f, 1.0f, 0.995f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

