/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.renderer;

import com.javic.slimpatch.client.model.HumanVindicatorModelFemale;
import com.javic.slimpatch.client.model.HumanVindicatorModelMale;
import com.javic.slimpatch.entity.HumanVindicatorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class HumanVindicatorRenderer
extends MobRenderer<HumanVindicatorEntity, HumanoidModel<HumanVindicatorEntity>> {
    private final HumanoidModel<HumanVindicatorEntity> maleModel;
    private final HumanoidModel<HumanVindicatorEntity> femaleModel;

    public HumanVindicatorRenderer(EntityRendererProvider.Context context) {
        super(context, new HumanVindicatorModelMale(context.bakeLayer(HumanVindicatorModelMale.LAYER_LOCATION)), 0.5f);
        this.maleModel = new HumanVindicatorModelMale<HumanVindicatorEntity>(context.bakeLayer(HumanVindicatorModelMale.LAYER_LOCATION));
        this.femaleModel = new HumanVindicatorModelFemale<HumanVindicatorEntity>(context.bakeLayer(HumanVindicatorModelFemale.LAYER_LOCATION));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(HumanVindicatorEntity entity) {
        return entity.getSkinTexture();
    }

    public void render(HumanVindicatorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.model = entity.isFemale() ? this.femaleModel : this.maleModel;
        poseStack.pushPose();
        poseStack.scale(entity.isFemale() ? 0.95f : 1.0f, entity.isFemale() ? 0.95f : 1.0f, entity.isFemale() ? 0.95f : 1.0f);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

