/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.client.renderer;

import com.javic.slimpatch.client.model.FemaleVillagerModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;

public class HumanWitchRenderer
extends MobRenderer<Witch, HumanoidModel<Witch>> {
    public HumanWitchRenderer(EntityRendererProvider.Context context) {
        super(context, new FemaleVillagerModel(context.bakeLayer(FemaleVillagerModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Witch entity) {
        CompoundTag tag = entity.getPersistentData();
        if (!tag.contains("hw_skin")) {
            int skinIndex = entity.getRandom().nextInt(10) + 1;
            tag.putInt("hw_skin", skinIndex);
        }
        int index = tag.getInt("hw_skin");
        return ResourceLocation.fromNamespaceAndPath((String)"slimpatch", (String)("textures/entity/human_witch/skin_" + String.format("%02d", index) + ".png"));
    }

    public void render(Witch entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(0.95f, 0.95f, 0.95f);
        poseStack.scale(0.93f, 1.0f, 0.93f);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

