/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.commands;

import com.javic.slimpatch.ModEntities;
import com.javic.slimpatch.SlimPatch;
import com.javic.slimpatch.entity.HumanWanderingTraderEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class SpawnHumanTraderCommand {
    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn_human_trader_test").requires(source -> source.hasPermission(2))).executes(context -> SpawnHumanTraderCommand.execute((CommandSourceStack)context.getSource())));
    }

    private static int execute(CommandSourceStack source) {
        ServerLevel level = source.getLevel();
        BlockPos pos = BlockPos.containing((Position)source.getPosition());
        try {
            EntityType traderType = (EntityType)ModEntities.HUMAN_WANDERING_TRADER.get();
            HumanWanderingTraderEntity trader = (HumanWanderingTraderEntity)traderType.create((Level)level);
            if (trader == null) {
                source.sendFailure((Component)Component.literal((String)"\u274c No se pudo crear el trader humano."));
                return 0;
            }
            trader.moveTo(pos.getX(), pos.getY(), pos.getZ(), level.random.nextFloat() * 360.0f, 0.0f);
            level.addFreshEntity((Entity)trader);
            for (int i = 0; i < 2; ++i) {
                TraderLlama llama = (TraderLlama)EntityType.TRADER_LLAMA.create((Level)level);
                if (llama == null) continue;
                double offset = i == 0 ? 2.0 : -2.0;
                llama.moveTo((double)pos.getX() + offset, (double)pos.getY(), (double)pos.getZ(), level.random.nextFloat() * 360.0f, 0.0f);
                llama.setLeashedTo((Entity)trader, true);
                level.addFreshEntity((Entity)llama);
            }
            source.sendSuccess(() -> Component.literal((String)"\u2705 Trader humano spawneado con dos llamas atadas."), false);
            SlimPatch.LOGGER.info("[SlimPatch] Comando ejecutado: trader humano + 2 llamas.");
            return 1;
        }
        catch (Exception e) {
            SlimPatch.LOGGER.error("[SlimPatch] Error al ejecutar /spawn_human_trader_test", (Throwable)e);
            source.sendFailure((Component)Component.literal((String)"\u274c Error al crear el trader humano."));
            return 0;
        }
    }
}

