/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.commands;

import com.javic.slimpatch.sounds.HumanIllagerSounds;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class TestIllagerSoundCommand {
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"testillager").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            builder.suggest("male_ambient");
            builder.suggest("female_ambient");
            builder.suggest("male_hurt");
            builder.suggest("female_hurt");
            builder.suggest("male_death");
            builder.suggest("female_death");
            return builder.buildFuture();
        }).executes(TestIllagerSoundCommand::playSound)));
    }

    private static int playSound(CommandContext<CommandSourceStack> ctx) {
        try {
            SoundEvent sound;
            String type;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            switch (type = StringArgumentType.getString(ctx, (String)"type")) {
                case "male_ambient": {
                    SoundEvent soundEvent = HumanIllagerSounds.maleAmbient();
                    break;
                }
                case "female_ambient": {
                    SoundEvent soundEvent = HumanIllagerSounds.femaleAmbient();
                    break;
                }
                case "male_hurt": {
                    SoundEvent soundEvent = HumanIllagerSounds.maleHurt();
                    break;
                }
                case "female_hurt": {
                    SoundEvent soundEvent = HumanIllagerSounds.femaleHurt();
                    break;
                }
                case "male_death": {
                    SoundEvent soundEvent = HumanIllagerSounds.maleDeath();
                    break;
                }
                case "female_death": {
                    SoundEvent soundEvent = HumanIllagerSounds.femaleDeath();
                    break;
                }
                default: {
                    SoundEvent soundEvent = sound = null;
                }
            }
            if (sound == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u26a0\ufe0f Error: tipo desconocido o SoundEvent no registrado."));
                return 0;
            }
            player.playNotifySound(sound, SoundSource.HOSTILE, 1.0f, 1.0f);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u2705 Reproduciendo sonido: " + type)), false);
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"No se pudo obtener el jugador."));
        }
        return 1;
    }
}

