/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.data;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldSkinData
extends SavedData {
    private String skinTheme = "";

    public static WorldSkinData load(CompoundTag tag, HolderLookup.Provider registries) {
        WorldSkinData data = new WorldSkinData();
        if (tag.contains("SkinTheme")) {
            data.skinTheme = tag.getString("SkinTheme");
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putString("SkinTheme", this.skinTheme);
        return tag;
    }

    public static WorldSkinData get(ServerLevel level) {
        return (WorldSkinData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldSkinData::new, WorldSkinData::load), "slimpatch_skin_data");
    }

    public void setTheme(String theme) {
        this.skinTheme = theme;
        this.setDirty();
    }

    public String getTheme() {
        return this.skinTheme;
    }

    public boolean isInitialized() {
        return this.skinTheme != null && !this.skinTheme.isEmpty();
    }
}

