/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.dialogue;

import com.javic.slimpatch.dialogue.DialogueManager;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class DialogueGoal
extends Goal {
    private final Villager villager;

    public DialogueGoal(Villager villager) {
        this.villager = villager;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return DialogueManager.isInDialogue(this.villager);
    }

    public boolean canContinueToUse() {
        return DialogueManager.isInDialogue(this.villager);
    }

    public void start() {
        this.villager.getNavigation().stop();
    }

    public void tick() {
        Player player;
        UUID playerId = DialogueManager.getDialoguePlayer(this.villager);
        if (playerId != null && (player = this.villager.level().getPlayerByUUID(playerId)) instanceof Player) {
            Player player2 = player;
            this.villager.getNavigation().stop();
            this.villager.getLookControl().setLookAt((Entity)player2, 30.0f, 30.0f);
        }
    }

    public void stop() {
        this.villager.getNavigation().stop();
    }
}

