/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.entity;

import com.javic.slimpatch.SlimPatch;
import com.javic.slimpatch.dialogue.DialogueGoal;
import com.javic.slimpatch.dialogue.DialogueManager;
import com.javic.slimpatch.entity.VillagerPersonality;
import com.javic.slimpatch.network.VillagerCooldownsPacket;
import com.javic.slimpatch.sounds.HumanVillagerSounds;
import com.javic.slimpatch.util.SkinPathHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class MaleVillagerEntity
extends Villager {
    private static final int MALE_SKINS = 70;
    private static final EntityDataAccessor<Integer> DATA_SKIN = SynchedEntityData.defineId(MaleVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> DATA_PERSONALITY = SynchedEntityData.defineId(MaleVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> DATA_RELATIONSHIP = SynchedEntityData.defineId(MaleVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final String[] MALE_NAMES = new String[]{"Adam", "Adrian", "Alexander", "Alfred", "Andrew", "Anthony", "Arthur", "Benjamin", "Blake", "Brandon", "Brian", "Caleb", "Cameron", "Carl", "Charles", "Christian", "Christopher", "Colin", "Connor", "Daniel", "David", "Dean", "Dominic", "Dylan", "Edward", "Elias", "Elijah", "Elliot", "Ethan", "Evan", "Felix", "Finn", "Francis", "Gabriel", "Gavin", "George", "Grant", "Gregory", "Harold", "Harrison", "Harry", "Henry", "Hugh", "Ian", "Isaac", "Jack", "Jacob", "James", "Jason", "Jeremy", "Joel", "John", "Jonathan", "Joseph", "Joshua", "Julian", "Keith", "Kenneth", "Kevin", "Kyle", "Liam", "Logan", "Louis", "Lucas", "Luke", "Malcolm", "Marcus", "Mark", "Martin", "Matthew", "Michael", "Nathan", "Nicholas", "Noah", "Oliver", "Oscar", "Owen", "Patrick", "Paul", "Peter", "Philip", "Raymond", "Richard", "Robert", "Ryan", "Samuel", "Scott", "Sean", "Simon", "Stephen", "Theodore", "Thomas", "Timothy", "Tristan", "Victor", "Vincent", "Walter", "William", "Zachary", "Ezekiel"};
    private static final Map<String, Long> OPTION_COOLDOWNS = Map.of("Friendly", 60000L, "Mean", 30000L, "Joke", 120000L, "Flirt", 180000L);
    private final Map<String, Long> optionCooldowns = new HashMap<String, Long>();

    public MaleVillagerEntity(EntityType<? extends Villager> type, Level level) {
        super(type, level);
        SlimPatch.LOGGER.info("[SlimPatch] Constructor MaleVillagerEntity llamado (level={})", (Object)level.dimension().location());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SKIN, (Object)0);
        builder.define(DATA_PERSONALITY, (Object)"FRIENDLY");
        builder.define(DATA_RELATIONSHIP, (Object)Float.valueOf(0.5f));
    }

    public void setSkinIndex(int index) {
        this.entityData.set(DATA_SKIN, (Object)index);
        this.getPersistentData().putInt("slimpatch_skin", index);
    }

    public int getSkinIndex() {
        return (Integer)this.entityData.get(DATA_SKIN);
    }

    public ResourceLocation getSkinTexture() {
        return SkinPathHelper.getSkin("male", this.getSkinIndex(), this.level());
    }

    public VillagerPersonality getPersonality() {
        try {
            return VillagerPersonality.valueOf((String)this.entityData.get(DATA_PERSONALITY));
        }
        catch (IllegalArgumentException e) {
            return VillagerPersonality.FRIENDLY;
        }
    }

    public void setPersonality(VillagerPersonality personality) {
        this.entityData.set(DATA_PERSONALITY, (Object)personality.name());
        this.getPersistentData().putString("slimpatch_personality", personality.name());
    }

    public float getRelationship() {
        return ((Float)this.entityData.get(DATA_RELATIONSHIP)).floatValue();
    }

    public void setRelationship(float value) {
        float clamped = Math.max(0.0f, Math.min(5.0f, value));
        this.entityData.set(DATA_RELATIONSHIP, (Object)Float.valueOf(clamped));
        this.getPersistentData().putFloat("slimpatch_relationship", clamped);
    }

    public void applyRelationshipChange(String option) {
        boolean success = DialogueManager.calculateSuccess(this.getPersonality(), option);
        this.applyRelationshipChange(option, success);
    }

    public void applyRelationshipChange(String option, boolean success) {
        Level level;
        long cooldown;
        long lastTime;
        long now = System.currentTimeMillis();
        if (this.optionCooldowns.containsKey(option) && now - (lastTime = this.optionCooldowns.get(option).longValue()) < (cooldown = OPTION_COOLDOWNS.getOrDefault(option, 20000L).longValue())) {
            SlimPatch.LOGGER.info("[SlimPatch] Opci\u00f3n '{}' en cooldown para {}", (Object)option, (Object)this.getName().getString());
            return;
        }
        this.optionCooldowns.put(option, now);
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uuid = this.getUUID();
            serverLevel.getServer().getPlayerList().getPlayers().forEach(player -> {
                if (player.distanceToSqr((Entity)this) < 4096.0) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new VillagerCooldownsPacket(uuid, this.getId(), this.getCooldownsForClient()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
        VillagerPersonality personality = this.getPersonality();
        float delta = DialogueManager.getRelationshipChange(personality, option, success);
        float old = this.getRelationship();
        this.setRelationship(old + delta);
        if (delta > 0.0f) {
            this.level().playSound(null, this.blockPosition(), HumanVillagerSounds.maleReactionPositive(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            for (int i = 0; i < 7; ++i) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX() + this.random.nextGaussian() * 0.3, this.getY() + 1.0, this.getZ() + this.random.nextGaussian() * 0.3, 1, 0.0, 0.0, 0.0, 0.0);
            }
        } else if (delta < 0.0f) {
            this.level().playSound(null, this.blockPosition(), HumanVillagerSounds.maleReactionNegative(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            for (int i = 0; i < 4; ++i) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX() + this.random.nextGaussian() * 0.3, this.getY() + 1.0, this.getZ() + this.random.nextGaussian() * 0.3, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        SlimPatch.LOGGER.info("[SlimPatch] {} ({}) \u2192 opci\u00f3n '{}' \u2192 \u0394rel={} (success={})", new Object[]{this.getName().getString(), personality.name(), option, Float.valueOf(delta), success});
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new DialogueGoal(this));
    }

    public boolean isBaby() {
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, reason, spawnData);
        CompoundTag data = this.getPersistentData();
        if (!data.contains("slimpatch_initialized")) {
            data.putString("slimpatch_gender", "male");
            data.putBoolean("slimpatch_forced", true);
            if (!data.contains("slimpatch_skin")) {
                int skinIndex = this.getRandom().nextInt(70) + 1;
                this.setSkinIndex(skinIndex);
                data.putInt("slimpatch_skin", skinIndex);
            } else {
                this.setSkinIndex(data.getInt("slimpatch_skin"));
            }
            String chosenName = MALE_NAMES[this.getRandom().nextInt(MALE_NAMES.length)];
            this.setCustomName((Component)Component.literal((String)chosenName));
            this.setCustomNameVisible(true);
            if (!data.contains("slimpatch_personality")) {
                this.setPersonality(VillagerPersonality.getRandom(this.getRandom()));
            } else {
                try {
                    this.setPersonality(VillagerPersonality.valueOf(data.getString("slimpatch_personality")));
                }
                catch (IllegalArgumentException e) {
                    this.setPersonality(VillagerPersonality.getRandom(this.getRandom()));
                }
            }
            this.setRelationship(0.5f);
            data.putBoolean("slimpatch_named", true);
            data.putBoolean("slimpatch_initialized", true);
        }
        SlimPatch.LOGGER.info("[SlimPatch] MaleVillagerEntity inicializado: skin={} name={} personality={} relationship={}", new Object[]{this.getSkinIndex(), this.getName().getString(), this.getPersonality(), Float.valueOf(this.getRelationship())});
        return groupData;
    }

    public boolean shouldShowName() {
        Player nearestPlayer = this.level().getNearestPlayer((Entity)this, 8.0);
        return nearestPlayer != null && this.hasCustomName();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide && hand == InteractionHand.MAIN_HAND) {
            this.level().playSound(null, this.blockPosition(), HumanVillagerSounds.maleClick(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return super.mobInteract(player, hand);
    }

    protected SoundEvent getAmbientSound() {
        return HumanVillagerSounds.maleClick();
    }

    public int getAmbientSoundInterval() {
        return 500;
    }

    public SoundEvent getNotifyTradeSound() {
        return HumanVillagerSounds.maleClick();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return HumanVillagerSounds.maleHurt();
    }

    protected SoundEvent getDeathSound() {
        return HumanVillagerSounds.maleDeath();
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("slimpatch_skin")) {
            this.setSkinIndex(tag.getInt("slimpatch_skin"));
        }
        if (tag.contains("slimpatch_personality")) {
            try {
                this.setPersonality(VillagerPersonality.valueOf(tag.getString("slimpatch_personality")));
            }
            catch (IllegalArgumentException e) {
                this.setPersonality(VillagerPersonality.getRandom(this.getRandom()));
            }
        }
        if (tag.contains("slimpatch_relationship")) {
            this.setRelationship(tag.getFloat("slimpatch_relationship"));
        } else {
            this.setRelationship(0.5f);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("slimpatch_skin", this.getSkinIndex());
        tag.putString("slimpatch_personality", this.getPersonality().name());
        tag.putFloat("slimpatch_relationship", this.getRelationship());
    }

    public Map<String, Integer> getCooldownsForClient() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : this.optionCooldowns.entrySet()) {
            long elapsed = now - entry.getValue();
            long remaining = Math.max(0L, OPTION_COOLDOWNS.getOrDefault(entry.getKey(), 20000L) - elapsed);
            result.put(entry.getKey(), (int)(remaining / 1000L));
        }
        return result;
    }
}

