/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.events;

import com.javic.slimpatch.ModEntities;
import com.javic.slimpatch.SlimPatch;
import com.javic.slimpatch.entity.HumanWanderingTraderEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="slimpatch")
public class HumanWanderingTraderSpawner {
    private static final int CHECK_INTERVAL_TICKS = 168000;
    private static final int MAX_ACTIVE_TRADERS = 20;
    private static final int SPAWN_RADIUS = 48;
    private static int tickCounter = 0;
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (++tickCounter < 168000) {
            return;
        }
        tickCounter = 0;
        for (ServerLevel level : event.getServer().getAllLevels()) {
            HumanWanderingTraderEntity trader;
            List players;
            AABB searchArea;
            List traders;
            if (level.dimension() != Level.OVERWORLD || (traders = level.getEntitiesOfClass(HumanWanderingTraderEntity.class, searchArea = new AABB(-10000.0, -64.0, -10000.0, 10000.0, 512.0, 10000.0))).size() >= 20 || (players = level.players()).isEmpty()) continue;
            ServerPlayer player = (ServerPlayer)players.get(random.nextInt(players.size()));
            int dx = random.nextInt(96) - 48;
            int dz = random.nextInt(96) - 48;
            BlockPos pos = player.blockPosition().offset(dx, 0, dz);
            BlockPos surfacePos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            BlockState blockBelow = level.getBlockState(surfacePos.below());
            boolean isSolid = blockBelow.isSolid();
            int light = level.getMaxLocalRawBrightness(surfacePos);
            if (!isSolid || light < 8 || (trader = (HumanWanderingTraderEntity)((EntityType)ModEntities.HUMAN_TRADER_NATURAL.get()).create((Level)level)) == null) continue;
            trader.moveTo(Vec3.atBottomCenterOf((Vec3i)surfacePos));
            trader.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(surfacePos), MobSpawnType.NATURAL, null);
            level.addFreshEntity((Entity)trader);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7eA merchant has arrived nearby."), false);
            SlimPatch.LOGGER.info("[SlimPatch] \ud83e\uddf3 Comerciante humano errante spawneado en {} ({})", (Object)surfacePos, (Object)level.dimension().location());
        }
    }
}

