/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.item;

import com.javic.slimpatch.SlimPatch;
import java.util.Random;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;

public class GenderedVillagerEggItem
extends SpawnEggItem {
    private final boolean isMale;
    private static final int MALE_SKINS = 35;
    private static final int FEMALE_SKINS = 35;

    public GenderedVillagerEggItem(EntityType<? extends Mob> type, boolean isMale, Item.Properties props) {
        super(type, 0, 0, props);
        this.isMale = isMale;
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        CompoundTag entityTag = new CompoundTag();
        CompoundTag slimpatchData = new CompoundTag();
        int skinIndex = this.isMale ? new Random().nextInt(35) + 1 : new Random().nextInt(35) + 1;
        slimpatchData.putInt("slimpatch_skin", skinIndex);
        slimpatchData.putString("slimpatch_gender", this.isMale ? "male" : "female");
        slimpatchData.putBoolean("slimpatch_forced", true);
        entityTag.put("ForgeData", (Tag)slimpatchData);
        CompoundTag root = new CompoundTag();
        root.put("EntityTag", (Tag)entityTag);
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)root));
        return stack;
    }

    public InteractionResult useOn(UseOnContext context) {
        SlimPatch.LOGGER.info("[SlimPatch] Huevo {} usado en posici\u00f3n {} en dimensi\u00f3n {}", new Object[]{this.isMale ? "male" : "female", context.getClickedPos(), context.getLevel().dimension().location()});
        return super.useOn(context);
    }
}

