/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.network;

import com.javic.slimpatch.SlimPatch;
import com.javic.slimpatch.data.WorldSkinData;
import com.javic.slimpatch.network.SyncSkinThemePacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class LoginHandler {
    public static void register() {
        NeoForge.EVENT_BUS.register(LoginHandler.class);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = player2.serverLevel();
        String theme = WorldSkinData.get(level).getTheme();
        SlimPatch.LOGGER.info("[SlimPatch] Enviando tema de skins '{}' al cliente {}", (Object)theme, (Object)player2.getGameProfile().getName());
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncSkinThemePacket(theme), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            ServerPlayer player = event.getPlayer();
            ServerLevel level = player.serverLevel();
            String theme = WorldSkinData.get(level).getTheme();
            SlimPatch.LOGGER.info("[SlimPatch] Re-sincronizando tema de skins '{}' al cliente {}", (Object)theme, (Object)player.getGameProfile().getName());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncSkinThemePacket(theme), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

