/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.network;

import com.javic.slimpatch.entity.FemaleVillagerEntity;
import com.javic.slimpatch.entity.MaleVillagerEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RelationshipPacket
implements CustomPacketPayload {
    private final int entityId;
    private final String option;
    private final boolean success;
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"slimpatch", (String)"relationship");
    public static final CustomPacketPayload.Type<RelationshipPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RelationshipPacket> CODEC = StreamCodec.of(RelationshipPacket::encode, RelationshipPacket::decode);

    public RelationshipPacket(int entityId, String option, boolean success) {
        this.entityId = entityId;
        this.option = option;
        this.success = success;
    }

    private static void encode(FriendlyByteBuf buf, RelationshipPacket packet) {
        buf.writeVarInt(packet.entityId);
        buf.writeUtf(packet.option);
        buf.writeBoolean(packet.success);
    }

    private static RelationshipPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readVarInt();
        String option = buf.readUtf();
        boolean success = buf.readBoolean();
        return new RelationshipPacket(entityId, option, success);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RelationshipPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ServerLevel level = player.serverLevel();
            Entity entity = level.getEntity(msg.entityId);
            if (entity instanceof MaleVillagerEntity) {
                MaleVillagerEntity male = (MaleVillagerEntity)entity;
                male.applyRelationshipChange(msg.option, msg.success);
            } else if (entity instanceof FemaleVillagerEntity) {
                FemaleVillagerEntity female = (FemaleVillagerEntity)entity;
                female.applyRelationshipChange(msg.option, msg.success);
            }
        });
    }
}

