/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.network;

import com.javic.slimpatch.SlimPatch;
import com.javic.slimpatch.dialogue.DialogueManager;
import com.javic.slimpatch.network.VillagerCooldownsPacket;
import com.javic.slimpatch.network.VillagerCooldownsStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ServerCooldownTracker {
    private static int tickCounter = 0;

    public static void init() {
        NeoForge.EVENT_BUS.register(ServerCooldownTracker.class);
        SlimPatch.LOGGER.info("[SlimPatch] \ud83d\udd04 ServerCooldownTracker registrado en NeoForge.");
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        SlimPatch.LOGGER.info("[SlimPatch] \ud83d\udfe2 ServerCooldownTracker iniciado correctamente.");
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        if (++tickCounter % 20 != 0) {
            return;
        }
        HashMap<UUID, Map<String, Integer>> allCooldowns = new HashMap<UUID, Map<String, Integer>>(VillagerCooldownsStorage.getAll());
        if (allCooldowns.isEmpty()) {
            return;
        }
        for (Map.Entry entry : allCooldowns.entrySet()) {
            ServerPlayer player;
            UUID villagerUUID = (UUID)entry.getKey();
            Map cooldowns = (Map)entry.getValue();
            boolean changed = false;
            HashMap<String, Integer> updated = new HashMap<String, Integer>();
            for (Map.Entry c : cooldowns.entrySet()) {
                int oldValue = (Integer)c.getValue();
                int newValue = Math.max(0, oldValue - 1);
                updated.put((String)c.getKey(), newValue);
                if (newValue == oldValue) continue;
                changed = true;
            }
            if (!changed) continue;
            VillagerCooldownsStorage.setCooldowns(villagerUUID, updated);
            Villager villager = ServerCooldownTracker.findVillagerByUUID(server, villagerUUID);
            if (villager == null) continue;
            villager.getPersistentData().putInt("slimpatch_cooldown_last_tick", (int)(System.currentTimeMillis() / 1000L));
            UUID playerUUID = DialogueManager.getDialoguePlayer(villager);
            if (playerUUID == null || (player = server.getPlayerList().getPlayer(playerUUID)) == null) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new VillagerCooldownsPacket(villager.getUUID(), villager.getId(), updated), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static Villager findVillagerByUUID(MinecraftServer server, UUID uuid) {
        if (server == null) {
            return null;
        }
        for (ServerLevel level : server.getAllLevels()) {
            Entity e = level.getEntity(uuid);
            if (!(e instanceof Villager)) continue;
            Villager v = (Villager)e;
            return v;
        }
        return null;
    }
}

