/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.network;

import com.javic.slimpatch.SlimPatch;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class VillagerCooldownsStorage {
    private static final Map<UUID, Map<String, Integer>> DATA = new HashMap<UUID, Map<String, Integer>>();
    private static final Map<Integer, UUID> ID_LINKS = new HashMap<Integer, UUID>();

    public static void setCooldowns(UUID uuid, Map<String, Integer> cooldowns) {
        if (uuid == null) {
            return;
        }
        DATA.put(uuid, new HashMap<String, Integer>(cooldowns));
        SlimPatch.LOGGER.debug("[SlimPatch] \u2705 Cooldowns actualizados para aldeano UUID {}", (Object)uuid);
    }

    public static Map<String, Integer> getCooldowns(UUID uuid) {
        return DATA.getOrDefault(uuid, Collections.emptyMap());
    }

    public static Map<UUID, Map<String, Integer>> getAll() {
        SlimPatch.LOGGER.debug("[SlimPatch] \ud83d\udd52 getAll() \u2192 {} aldeanos con cooldowns activos", (Object)DATA.size());
        return new HashMap<UUID, Map<String, Integer>>(DATA);
    }

    public static void ensureLinked(int entityId, UUID uuid) {
        if (!ID_LINKS.containsKey(entityId)) {
            ID_LINKS.put(entityId, uuid);
            SlimPatch.LOGGER.debug("[SlimPatch] Vinculado entityId {} \u2194 UUID {}", (Object)entityId, (Object)uuid);
        }
    }

    public static UUID getUUIDFromEntityId(int entityId) {
        return ID_LINKS.get(entityId);
    }

    public static void clear() {
        DATA.clear();
        ID_LINKS.clear();
        SlimPatch.LOGGER.debug("[SlimPatch] VillagerCooldownsStorage reseteado");
    }
}

