/*
 * Decompiled with CFR 0.152.
 */
package com.javic.slimpatch.util;

import com.javic.slimpatch.client.ClientSkinTheme;
import com.javic.slimpatch.data.WorldSkinData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class SkinPathHelper {
    public static ResourceLocation getSkin(String gender, int skinId, Level level) {
        return SkinPathHelper.getSkinForType("custom_villager", gender, skinId, level);
    }

    public static ResourceLocation getSkinForType(String type, String gender, int skinId, Level level) {
        String theme = null;
        boolean useTheme = "custom_villager".equals(type);
        if (useTheme) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                theme = WorldSkinData.get(serverLevel).getTheme();
            } else {
                theme = ClientSkinTheme.getTheme();
            }
            if (theme == null || theme.isEmpty()) {
                theme = "modern";
            }
        }
        StringBuilder path = new StringBuilder("slimpatch:textures/entity/").append(type).append("/");
        if (useTheme && "fantasy".equalsIgnoreCase(theme)) {
            path.append("fantasy/");
        }
        path.append(gender.toLowerCase()).append("/skin_");
        if (useTheme || type.equals("human_trader") || type.equals("human_witch")) {
            path.append(skinId);
        } else {
            path.append(String.format("%02d", skinId));
        }
        path.append(".png");
        ResourceLocation loc = ResourceLocation.tryParse((String)path.toString());
        if (loc == null) {
            loc = ResourceLocation.tryParse((String)("slimpatch:textures/entity/" + type + "/" + gender + "/skin_1.png"));
        }
        return loc;
    }

    public static ResourceLocation from(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"slimpatch", (String)path);
    }
}

