/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;

public class RascalModel<T extends AbstractKoboldState>
extends KoboldModel<T> {
    public final ModelPart bag;

    public RascalModel(ModelPart root) {
        super(root);
        this.bag = root.getChild("bag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = KoboldModel.createMesh(new CubeDeformation(0.0f), 0.0f);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("bag", CubeListBuilder.create().texOffs(26, 30).addBox(-1.0f, 0.0f, 2.0f, 5.0f, 7.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(33, 7).addBox(-5.0f, -0.85f, -1.5f, 8.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T kobold) {
        this.rightArm.xRot = Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 2.0f * ((AbstractKoboldState)((Object)kobold)).walkAnimationSpeed * 0.5f;
        this.leftArm.xRot = -0.7854f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.body.xRot = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).walkAnimationPos * 0.6662f)) * 1.4f * ((AbstractKoboldState)((Object)kobold)).walkAnimationSpeed;
        this.leftLeg.xRot = Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((AbstractKoboldState)((Object)kobold)).walkAnimationSpeed;
        this.head.yRot = ((AbstractKoboldState)((Object)kobold)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((AbstractKoboldState)((Object)kobold)).xRot * ((float)Math.PI / 180);
        this.rightArm.zRot += Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.leftArm.zRot -= Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (((AbstractKoboldState)((Object)kobold)).isPassenger) {
            this.rightLeg.xRot = -1.5708f;
            this.leftLeg.xRot = -1.5708f;
            this.rightLeg.yRot = 0.2618f;
            this.leftLeg.yRot = -0.2618f;
        }
        if (!kobold.getMainHandItem().isEmpty() && ((AbstractKoboldState)((Object)kobold)).isAggressive) {
            this.rightArm.xRot = -2.0944f;
            this.rightArm.yRot = 0.1745f;
        }
        if (((AbstractKoboldState)((Object)kobold)).attackTime > 0.0f) {
            if (((AbstractKoboldState)((Object)kobold)).isAggressive) {
                float progress = ((AbstractKoboldState)((Object)kobold)).attackTime;
                progress = 1.0f - ((AbstractKoboldState)((Object)kobold)).attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 / 1.2 - 1.0));
            } else {
                float progress = ((AbstractKoboldState)((Object)kobold)).attackTime;
                this.body.yRot = Mth.sin((float)(Mth.sqrt((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                this.rightArm.yRot += this.body.yRot;
                this.leftArm.yRot += this.body.yRot;
                this.leftArm.xRot += this.body.yRot;
                progress = 1.0f - ((AbstractKoboldState)((Object)kobold)).attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                float f3 = Mth.sin((float)(((AbstractKoboldState)((Object)kobold)).attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
                this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 * 1.2 + (double)f3));
                this.rightArm.yRot += this.body.yRot * 2.0f;
                this.rightArm.zRot += Mth.sin((float)(((AbstractKoboldState)((Object)kobold)).attackTime * (float)Math.PI)) * -0.4f;
            }
        }
    }

    @Override
    public void translateToHand(AbstractKoboldState state, HumanoidArm arm, PoseStack pose) {
        switch (arm) {
            case LEFT: 
            case RIGHT: {
                this.rightArm.translateAndRotate(pose);
                pose.translate(-0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
            }
        }
    }
}

