/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.ZomboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.client.renderer.layers.KoboldZombieEyesLayer;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldZombieRenderer
extends MobRenderer<KoboldZombie, AbstractKoboldState, ZomboldModel<AbstractKoboldState>> {
    public KoboldZombieRenderer(EntityRendererProvider.Context context) {
        super(context, new ZomboldModel(context.bakeLayer(KoboldsClient.ZOMBOLD)), 0.36f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new KoboldZombieEyesLayer(this));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, ArmorModelSet.bake(KoboldsClient.KOBOLD_ARMOR, (EntityModelSet)context.getModelSet(), ZomboldModel::new), ArmorModelSet.bake(KoboldsClient.KOBOLD_ARMOR, (EntityModelSet)context.getModelSet(), ZomboldModel::new), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(AbstractKoboldState zombo) {
        return zombo.texture;
    }

    public AbstractKoboldState createRenderState() {
        return new AbstractKoboldState();
    }

    public void extractRenderState(KoboldZombie zombo, AbstractKoboldState state, float f1) {
        super.extractRenderState((LivingEntity)zombo, (LivingEntityRenderState)state, f1);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)zombo, (HumanoidRenderState)state, (float)f1, (ItemModelResolver)this.itemModelResolver);
        state.texture = zombo.getName().getString().equals("James") && zombo.getZomboType().equals("enchanter") ? ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/undead/zombie_james.png") : ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/undead/zombie_" + zombo.getZomboType() + ".png"));
        state.isAggressive = zombo.isAggressive();
        state.isLeftHanded = zombo.isLeftHanded();
        state.getZomboType = zombo.getZomboType();
        state.isZomboConverting = zombo.isConvert();
        state.rightStack = zombo.getItemHeldByArm(HumanoidArm.RIGHT);
        state.leftStack = zombo.getItemHeldByArm(HumanoidArm.LEFT);
    }

    protected boolean isShaking(AbstractKoboldState zombo) {
        return zombo.isZomboConverting;
    }

    public void submit(AbstractKoboldState zombo, PoseStack pose, SubmitNodeCollector buffer, CameraRenderState c) {
        pose.pushPose();
        pose.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        pose.scale(scale, scale, scale);
        super.submit((LivingEntityRenderState)zombo, pose, buffer, c);
        pose.popPose();
    }
}

