/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldAttackSelector
implements TargetingConditions.Selector {
    private final AbstractKoboldEntity kobold;

    public KoboldAttackSelector(AbstractKoboldEntity source) {
        this.kobold = source;
    }

    public boolean test(@Nullable LivingEntity target, ServerLevel lvl) {
        if (target != null) {
            LivingEntity dragon;
            Entity entity;
            if (this.kobold.getDragonReference() != null && (entity = lvl.getEntity(this.kobold.getDragonReference().getUUID())) instanceof LivingEntity && this.kobold.distanceTo((Entity)(dragon = (LivingEntity)entity)) <= 32.0f) {
                if (dragon.getLastHurtByMob() != null && dragon.getLastHurtByMob().isAlive() && this.kobold.hasLineOfSight((Entity)dragon.getLastHurtByMob())) {
                    return target.is((Entity)dragon.getLastHurtByMob());
                }
                if (dragon.getLastHurtMob() != null && dragon.getLastHurtMob().isAlive() && this.kobold.hasLineOfSight((Entity)dragon.getLastHurtMob())) {
                    return target.is((Entity)dragon.getLastHurtMob());
                }
            }
            if (this.kobold instanceof KoboldWarrior) {
                return target.getType().is(KoboldsTags.TARGETZ);
            }
            return target.getType().is(KoboldsTags.TARGETS);
        }
        return false;
    }
}

