/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldWallSkull
extends WallSkullBlock {
    public KoboldWallSkull(SkullBlock.Type type, BlockBehaviour.Properties props) {
        super(type, props);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SkullBlockEntity(pos, state);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blok, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, world, pos, blok, fromPos, moving);
        if (world.getBestNeighborSignal(pos) > 0 && world instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)world;
            if (world.isNight() && world.canSeeSkyFromBelowWater(pos)) {
                this.summonSkelebold(lvl, BlockPos.containing((double)((double)pos.getX() + 0.5), (double)pos.getY(), (double)((double)pos.getZ() + 0.5)));
            }
        }
    }

    public void tick(BlockState blockstate, ServerLevel lvl, BlockPos pos, RandomSource random) {
        super.tick(blockstate, lvl, pos, random);
        if (lvl.isNight() && lvl.canSeeSkyFromBelowWater(pos)) {
            this.summonSkelebold(lvl, BlockPos.containing((double)((double)pos.getX() + 0.5), (double)pos.getY(), (double)((double)pos.getZ() + 0.5)));
        }
    }

    protected EntityType<?> getKoboldSkeleton() {
        return (EntityType)KoboldsMobs.KOBOLD_SKELETON.get();
    }

    private void summonSkelebold(ServerLevel lvl, BlockPos pos) {
        lvl.destroyBlock(pos, false);
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)lvl);
        bolt.move(MoverType.SELF, Vec3.atBottomCenterOf((Vec3i)pos));
        bolt.setVisualOnly(true);
        this.getKoboldSkeleton().spawn(lvl, pos, MobSpawnType.MOB_SUMMONED);
        lvl.addFreshEntity((Entity)bolt);
    }
}

