/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.TridentItem;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldTridentGoal
extends RangedAttackGoal {
    public final AbstractKoboldEntity kobold;

    public KoboldTridentGoal(AbstractKoboldEntity kobold, double d, int i, float f) {
        super((RangedAttackMob)kobold, d, i, f);
        this.kobold = kobold;
    }

    public boolean canUse() {
        return super.canUse() && this.isHoldingTrident();
    }

    public void start() {
        super.start();
        this.kobold.setAggressive(true);
        this.kobold.startUsingItem(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.kobold, item -> item instanceof TridentItem));
    }

    public void stop() {
        super.stop();
        this.kobold.setAggressive(false);
        this.kobold.stopUsingItem();
    }

    private boolean isHoldingTrident() {
        return this.kobold.isHolding(stack -> stack.getItem() instanceof TridentItem);
    }
}

