/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.api;

import com.min01.gravityapi.EntityTags;
import com.min01.gravityapi.RotationAnimation;
import com.min01.gravityapi.capabilities.GravityCapabilities;
import com.min01.gravityapi.capabilities.GravityCapabilityImpl;
import com.min01.gravityapi.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public abstract class GravityChangerAPI {
    public static Direction getGravityDirection(Entity entity) {
        GravityCapabilityImpl comp = GravityChangerAPI.getGravityComponentEarly(entity);
        if (comp == null) {
            return Direction.DOWN;
        }
        return comp.getCurrGravityDirection();
    }

    public static double getGravityStrength(Entity entity) {
        return GravityChangerAPI.getGravityComponent(entity).getCurrGravityStrength();
    }

    public static double getBaseGravityStrength(Entity entity) {
        return GravityChangerAPI.getGravityComponent(entity).getBaseGravityStrength();
    }

    public static void setBaseGravityStrength(Entity entity, double strength) {
        GravityCapabilityImpl component = GravityChangerAPI.getGravityComponent(entity);
        component.setBaseGravityStrength(strength);
    }

    public static void resetGravity(Entity entity) {
        if (!EntityTags.canChangeGravity(entity)) {
            return;
        }
        GravityChangerAPI.getGravityComponent(entity).reset();
    }

    public static Direction getBaseGravityDirection(Entity entity) {
        return GravityChangerAPI.getGravityComponent(entity).getBaseGravityDirection();
    }

    public static void setBaseGravityDirection(Entity entity, Direction gravityDirection) {
        GravityCapabilityImpl component = GravityChangerAPI.getGravityComponent(entity);
        component.setBaseGravityDirection(gravityDirection);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static RotationAnimation getRotationAnimation(Entity entity) {
        return GravityChangerAPI.getGravityComponent(entity).getRotationAnimation();
    }

    public static void instantlySetClientBaseGravityDirection(Entity entity, Direction direction) {
        Validate.isTrue((boolean)entity.m_9236_().m_5776_(), (String)"should only be used on client", (Object[])new Object[0]);
        GravityCapabilityImpl component = GravityChangerAPI.getGravityComponent(entity);
        component.setBaseGravityDirection(direction);
        component.updateGravityStatus(false);
        component.forceApplyGravityChange();
    }

    public static GravityCapabilityImpl getGravityComponent(Entity entity) {
        GravityCapabilityImpl cap = (GravityCapabilityImpl)entity.getCapability(GravityCapabilities.GRAVITY).orElse((Object)new GravityCapabilityImpl());
        return cap;
    }

    @Nullable
    public static GravityCapabilityImpl getGravityComponentEarly(Entity entity) {
        return GravityChangerAPI.getGravityComponent(entity);
    }

    public static Vec3 getWorldVelocity(Entity entity) {
        return RotationUtil.vecPlayerToWorld(entity.m_20184_(), GravityChangerAPI.getGravityDirection(entity));
    }

    public static void setWorldVelocity(Entity entity, Vec3 worldVelocity) {
        entity.m_20256_(RotationUtil.vecWorldToPlayer(worldVelocity, GravityChangerAPI.getGravityDirection(entity)));
    }

    public static Vec3 getEyeOffset(Entity entity) {
        return RotationUtil.vecPlayerToWorld(0.0, (double)entity.m_20192_(), 0.0, GravityChangerAPI.getGravityDirection(entity));
    }

    public static boolean canChangeGravity(Entity entity) {
        return EntityTags.canChangeGravity(entity);
    }
}

