/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.capabilities;

import com.min01.gravityapi.EntityTags;
import com.min01.gravityapi.RotationAnimation;
import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.api.RotationParameters;
import com.min01.gravityapi.capabilities.IGravityCapability;
import com.min01.gravityapi.config.GravityConfig;
import com.min01.gravityapi.init.GravityMobEffects;
import com.min01.gravityapi.item.GravityAnchorItem;
import com.min01.gravityapi.mixin.EntityAccessor;
import com.min01.gravityapi.mob_effect.GravityDirectionMobEffect;
import com.min01.gravityapi.mob_effect.GravityStrengthMobEffect;
import com.min01.gravityapi.network.GravityNetwork;
import com.min01.gravityapi.network.UpdateGravityCapabilityPacket;
import com.min01.gravityapi.util.GCUtil;
import com.min01.gravityapi.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GravityCapabilityImpl
implements IGravityCapability {
    private boolean initialized = false;
    private Direction prevGravityDirection = Direction.DOWN;
    private double prevGravityStrength = 1.0;
    Direction baseGravityDirection = Direction.DOWN;
    double baseGravityStrength = 1.0;
    @Nullable
    RotationParameters currentRotationParameters = RotationParameters.getDefault();
    @Nullable
    public RotationAnimation animation;
    public Entity entity;
    private Direction currGravityDirection = Direction.DOWN;
    private double currGravityStrength = 1.0;
    private double currentEffectPriority = Double.MIN_VALUE;
    private boolean isFiringUpdateEvent = false;
    @Nullable
    private GravityDirEffect delayApplyDirEffect = null;
    private double delayApplyStrengthEffect = 1.0;
    private long lastUpdateTickCount = 0L;
    private boolean needsSync = false;

    @Override
    public void setEntity(Entity entity) {
        this.entity = entity;
        this.animation = entity.f_19853_.m_5776_() ? new RotationAnimation() : null;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.baseGravityDirection = tag.m_128441_("baseGravityDirection") ? Direction.m_122402_((String)tag.m_128461_("baseGravityDirection")) : Direction.DOWN;
        this.baseGravityStrength = tag.m_128441_("baseGravityStrength") ? tag.m_128459_("baseGravityStrength") : 1.0;
        if (!this.initialized || this.shouldAcceptServerSync()) {
            this.currGravityDirection = tag.m_128441_("currentGravityDirection") ? Direction.m_122402_((String)tag.m_128461_("currentGravityDirection")) : Direction.DOWN;
            this.currGravityStrength = tag.m_128441_("currentGravityStrength") ? tag.m_128459_("currentGravityStrength") : 1.0;
        }
        if (!this.initialized) {
            this.prevGravityDirection = this.currGravityDirection;
            this.prevGravityStrength = this.currGravityStrength;
            this.initialized = true;
            this.needsSync = true;
            this.applyGravityDirectionChange(this.prevGravityDirection, this.currGravityDirection, this.currentRotationParameters, true);
        }
    }

    private boolean shouldAcceptServerSync() {
        return this.entity.m_9236_().m_5776_() && !GCUtil.isClientPlayer(this.entity);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("baseGravityDirection", this.baseGravityDirection.m_122433_());
        tag.m_128359_("currentGravityDirection", this.currGravityDirection.m_122433_());
        tag.m_128347_("baseGravityStrength", this.baseGravityStrength);
        tag.m_128347_("currentGravityStrength", this.currGravityStrength);
        return tag;
    }

    @Override
    public void tick() {
        if (!this.canChangeGravity()) {
            return;
        }
        this.updateGravityStatus(true);
        this.applyGravityChange();
        if (!this.entity.f_19853_.m_5776_() && this.needsSync) {
            this.needsSync = false;
            this.sendSyncPacketToOtherPlayers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGravityStatus(boolean sendPacketIfNecessary) {
        if (this.shouldAcceptServerSync()) {
            return;
        }
        Direction oldGravityDirection = this.currGravityDirection;
        double oldGravityStrength = this.currGravityStrength;
        Entity vehicle = this.entity.m_20202_();
        if (vehicle != null) {
            this.currGravityDirection = GravityChangerAPI.getGravityDirection(vehicle);
            this.currGravityStrength = GravityChangerAPI.getGravityStrength(vehicle);
        } else {
            this.currGravityDirection = this.baseGravityDirection;
            this.currGravityStrength = this.baseGravityStrength;
            this.currGravityStrength *= ((Double)GravityConfig.gravityStrengthMultiplier.get()).doubleValue();
            this.currentEffectPriority = Double.MIN_VALUE;
            this.isFiringUpdateEvent = true;
            try {
                LivingEntity living;
                Object handSlot2;
                for (Object handSlot2 : this.entity.m_6167_()) {
                    Item item = handSlot2.m_41720_();
                    if (!(item instanceof GravityAnchorItem)) continue;
                    GravityAnchorItem anchorItem = (GravityAnchorItem)item;
                    this.applyGravityDirectionEffect(anchorItem.direction, null, 1000000.0);
                }
                handSlot2 = this.entity;
                if (!(handSlot2 instanceof LivingEntity)) {
                    return;
                }
                LivingEntity livingEntity = (LivingEntity)handSlot2;
                for (GravityDirectionMobEffect dirEffect : GravityDirectionMobEffect.EFFECT_MAP.values()) {
                    MobEffectInstance effectInstance = livingEntity.m_21124_((MobEffect)dirEffect);
                    if (effectInstance == null) continue;
                    int amplifier = effectInstance.m_19564_();
                    this.applyGravityDirectionEffect(dirEffect.gravityDirection, null, (double)amplifier + 1.0);
                }
                Entity entity = this.entity;
                if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)GravityMobEffects.INVERT.get())) {
                    this.applyGravityDirectionEffect(this.getCurrGravityDirection().m_122424_(), null, 5.0);
                }
                if ((entity = this.entity) instanceof LivingEntity) {
                    living = (LivingEntity)entity;
                    ((GravityStrengthMobEffect)((Object)GravityMobEffects.INCREASE.get())).apply(living, this);
                    ((GravityStrengthMobEffect)((Object)GravityMobEffects.DECREASE.get())).apply(living, this);
                    ((GravityStrengthMobEffect)((Object)GravityMobEffects.REVERSE.get())).apply(living, this);
                }
                if (this.delayApplyDirEffect != null) {
                    this.applyGravityDirectionEffect(this.delayApplyDirEffect.direction(), this.delayApplyDirEffect.rotationParameters(), this.delayApplyDirEffect.priority());
                    this.delayApplyDirEffect = null;
                }
                this.currGravityStrength *= this.delayApplyStrengthEffect;
                this.delayApplyStrengthEffect = 1.0;
            }
            finally {
                this.isFiringUpdateEvent = false;
            }
            if (this.currentEffectPriority == Double.MIN_VALUE) {
                this.currentRotationParameters = RotationParameters.getDefault();
            }
            this.lastUpdateTickCount = this.entity.f_19797_;
        }
        if (sendPacketIfNecessary) {
            boolean changed;
            boolean bl = changed = oldGravityDirection != this.currGravityDirection || Math.abs(oldGravityStrength - this.currGravityStrength) > 1.0E-4;
            if (changed) {
                this.sendSyncPacketToOtherPlayers();
            }
        }
    }

    private void sendSyncPacketToOtherPlayers() {
        if (!this.entity.f_19853_.f_46443_) {
            GravityNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.entity), (Object)new UpdateGravityCapabilityPacket(this.entity.m_20148_(), this.baseGravityDirection, this.currGravityDirection, this.baseGravityStrength, this.currGravityStrength));
        }
    }

    @Override
    public void sync(Direction baseGravityDirection, Direction currentGravityDirection, double baseGravityStrength, double currentGravityStrength) {
        this.baseGravityDirection = baseGravityDirection;
        this.currGravityDirection = currentGravityDirection;
        this.baseGravityStrength = baseGravityStrength;
        this.currGravityStrength = currentGravityStrength;
    }

    public void applyGravityDirectionEffect(@NotNull Direction direction, @Nullable RotationParameters rotationParameters, double priority) {
        if (this.isFiringUpdateEvent) {
            if (priority > this.currentEffectPriority) {
                this.currentEffectPriority = priority;
                this.currGravityDirection = direction;
                if (rotationParameters != null) {
                    this.currentRotationParameters = rotationParameters;
                }
            }
        } else if (this.delayApplyDirEffect == null || priority > this.delayApplyDirEffect.priority()) {
            this.delayApplyDirEffect = new GravityDirEffect(direction, rotationParameters, priority);
        }
    }

    public void applyGravityStrengthEffect(double strengthMultiplier) {
        if (this.isFiringUpdateEvent) {
            this.currGravityStrength *= strengthMultiplier;
        } else {
            this.delayApplyStrengthEffect *= strengthMultiplier;
        }
    }

    public void applyGravityDirectionChange(Direction oldGravity, Direction newGravity, RotationParameters rotationParameters, boolean isInitialization) {
        if (!this.canChangeGravity()) {
            return;
        }
        this.entity.m_20011_(((EntityAccessor)this.entity).gc_makeBoundingBox());
        if (isInitialization) {
            return;
        }
        this.entity.f_19789_ = 0.0f;
        long timeMs = this.entity.m_9236_().m_46467_() * 50L;
        Vec3 relativeRotationCenter = GravityCapabilityImpl.getLocalRotationCenter(this.entity, oldGravity, newGravity, rotationParameters);
        Vec3 oldPos = this.entity.m_20182_();
        Vec3 oldLastTickPos = new Vec3(this.entity.f_19790_, this.entity.f_19791_, this.entity.f_19792_);
        Vec3 rotationCenter = oldPos.m_82549_(RotationUtil.vecPlayerToWorld(relativeRotationCenter, oldGravity));
        Vec3 newPos = rotationCenter.m_82546_(RotationUtil.vecPlayerToWorld(relativeRotationCenter, newGravity));
        Vec3 posTranslation = newPos.m_82546_(oldPos);
        Vec3 newLastTickPos = oldLastTickPos.m_82549_(posTranslation);
        this.entity.m_146884_(newPos);
        this.entity.f_19854_ = newLastTickPos.f_82479_;
        this.entity.f_19855_ = newLastTickPos.f_82480_;
        this.entity.f_19856_ = newLastTickPos.f_82481_;
        this.entity.f_19790_ = newLastTickPos.f_82479_;
        this.entity.f_19791_ = newLastTickPos.f_82480_;
        this.entity.f_19792_ = newLastTickPos.f_82481_;
        this.adjustEntityPosition(oldGravity, newGravity, this.entity.m_20191_());
        if (this.entity.m_9236_().m_5776_()) {
            Validate.notNull((Object)this.animation, (String)"gravity animation is null", (Object[])new Object[0]);
            int rotationTimeMS = rotationParameters.rotationTimeMS();
            this.animation.startRotationAnimation(newGravity, oldGravity, rotationTimeMS, this.entity, timeMs, rotationParameters.rotateView(), relativeRotationCenter);
        }
        Vec3 realWorldVelocity = GravityCapabilityImpl.getRealWorldVelocity(this.entity, oldGravity);
        if (rotationParameters.rotateVelocity()) {
            Vector3f worldSpaceVec = realWorldVelocity.m_252839_();
            worldSpaceVec.rotate((Quaternionfc)RotationUtil.getRotationBetween(oldGravity, newGravity));
            this.entity.m_20256_(RotationUtil.vecWorldToPlayer(new Vec3(worldSpaceVec), newGravity));
        } else {
            this.entity.m_20256_(RotationUtil.vecWorldToPlayer(realWorldVelocity, newGravity));
        }
    }

    private static Vec3 getRealWorldVelocity(Entity entity, Direction prevGravityDirection) {
        if (entity.m_6109_()) {
            return new Vec3(entity.m_20185_() - entity.f_19854_, entity.m_20186_() - entity.f_19855_, entity.m_20189_() - entity.f_19856_);
        }
        return RotationUtil.vecPlayerToWorld(entity.m_20184_(), prevGravityDirection);
    }

    @NotNull
    private static Vec3 getLocalRotationCenter(Entity entity, Direction oldGravity, Direction newGravity, RotationParameters rotationParameters) {
        if (entity instanceof EndCrystal) {
            return new Vec3(0.0, -0.5, 0.0);
        }
        EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
        if (newGravity.m_122424_() == oldGravity) {
            return new Vec3(0.0, (double)(dimensions.f_20378_ / 2.0f), 0.0);
        }
        return Vec3.f_82478_;
    }

    private void adjustEntityPosition(Direction oldGravity, Direction newGravity, AABB entityBoundingBox) {
        if (!((Boolean)GravityConfig.adjustPositionAfterChangingGravity.get()).booleanValue()) {
            return;
        }
        if (this.entity instanceof AreaEffectCloud || this.entity instanceof AbstractArrow || this.entity instanceof EndCrystal) {
            return;
        }
        Direction movingDirection = oldGravity.m_122424_();
        Iterable collisions = this.entity.m_9236_().m_186431_(this.entity, entityBoundingBox.m_82400_(-0.01));
        AABB totalCollisionBox = null;
        for (VoxelShape collision : collisions) {
            if (collision.m_83281_()) continue;
            AABB boundingBox = collision.m_83215_();
            if (totalCollisionBox == null) {
                totalCollisionBox = boundingBox;
                continue;
            }
            totalCollisionBox = totalCollisionBox.m_82367_(boundingBox);
        }
        if (totalCollisionBox != null) {
            Vec3 positionAdjustmentOffset = GravityCapabilityImpl.getPositionAdjustmentOffset(entityBoundingBox, totalCollisionBox, movingDirection);
            if (this.entity instanceof Player) {
                // empty if block
            }
            this.entity.m_146884_(this.entity.m_20182_().m_82549_(positionAdjustmentOffset));
        }
    }

    private static Vec3 getPositionAdjustmentOffset(AABB entityBoundingBox, AABB nearbyCollisionUnion, Direction movingDirection) {
        Direction.Axis axis = movingDirection.m_122434_();
        double offset = 0.0;
        if (movingDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            double pushed;
            double pushing = nearbyCollisionUnion.m_82374_(axis);
            if (pushing > (pushed = entityBoundingBox.m_82340_(axis))) {
                offset = pushing - pushed;
            }
        } else {
            double pushed;
            double pushing = nearbyCollisionUnion.m_82340_(axis);
            if (pushing < (pushed = entityBoundingBox.m_82374_(axis))) {
                offset = pushed - pushing;
            }
        }
        return new Vec3(movingDirection.m_253071_()).m_82490_(offset);
    }

    public double getBaseGravityStrength() {
        return this.baseGravityStrength;
    }

    public void setBaseGravityStrength(double strength) {
        if (!this.canChangeGravity()) {
            return;
        }
        this.baseGravityStrength = strength;
        this.needsSync = true;
    }

    public Direction getCurrGravityDirection() {
        return this.currGravityDirection;
    }

    public double getCurrGravityStrength() {
        return this.currGravityStrength;
    }

    private boolean canChangeGravity() {
        return EntityTags.canChangeGravity(this.entity);
    }

    public Direction getPrevGravityDirection() {
        return this.prevGravityDirection;
    }

    public Direction getBaseGravityDirection() {
        return this.baseGravityDirection;
    }

    public void setBaseGravityDirection(Direction gravityDirection) {
        if (!this.canChangeGravity()) {
            return;
        }
        if (this.baseGravityDirection != gravityDirection) {
            this.baseGravityDirection = gravityDirection;
            this.needsSync = true;
            this.updateGravityStatus(false);
        }
    }

    public void reset() {
        this.baseGravityDirection = Direction.DOWN;
        this.baseGravityStrength = 1.0;
        this.needsSync = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RotationAnimation getRotationAnimation() {
        return this.animation;
    }

    @Override
    public void applyGravityChange() {
        if (this.currentRotationParameters == null) {
            this.currentRotationParameters = RotationParameters.getDefault();
        }
        if (this.prevGravityDirection != this.currGravityDirection) {
            this.applyGravityDirectionChange(this.prevGravityDirection, this.currGravityDirection, this.currentRotationParameters, false);
            this.prevGravityDirection = this.currGravityDirection;
        }
        if (Math.abs(this.currGravityStrength - this.prevGravityStrength) > 1.0E-4) {
            this.prevGravityStrength = this.currGravityStrength;
        }
    }

    public void forceApplyGravityChange() {
        this.prevGravityDirection = this.currGravityDirection;
        this.prevGravityStrength = this.currGravityStrength;
    }

    private record GravityDirEffect(@NotNull Direction direction, @Nullable RotationParameters rotationParameters, double priority) {
    }
}

