/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.mixin;

import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.util.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityCollisionContext.class})
public abstract class EntityCollisionContextMixin {
    @Shadow
    @Final
    private Entity f_166002_;
    @Shadow
    @Final
    private double f_82867_;

    @Redirect(method={"<init>(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getY()D", ordinal=0))
    private static double redirect_init_getY_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20186_();
        }
        return RotationUtil.boxWorldToPlayer((AABB)entity.m_20191_(), (Direction)gravityDirection).f_82289_;
    }

    @Inject(method={"Lnet/minecraft/world/phys/shapes/EntityCollisionContext;isAbove(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/core/BlockPos;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_isAbove(VoxelShape shape, BlockPos pos, boolean defaultValue, CallbackInfoReturnable<Boolean> cir) {
        if (this.f_166002_ == null) {
            return;
        }
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this.f_166002_);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        if (shape.m_83281_()) {
            cir.setReturnValue((Object)true);
            return;
        }
        AABB shapeBox = RotationUtil.boxWorldToPlayer(shape.m_83215_().m_82400_((double)-1.0E-5f), gravityDirection);
        AABB posBox = RotationUtil.boxWorldToPlayer(new AABB(pos), gravityDirection);
        cir.setReturnValue((Object)(this.f_82867_ > posBox.f_82289_ + shapeBox.f_82291_ ? 1 : 0));
    }
}

