/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.mixin.client;

import com.min01.gravityapi.EntityTags;
import com.min01.gravityapi.RotationAnimation;
import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.util.RotationUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Shadow
    @Final
    private static RenderType f_114361_;
    @Shadow
    private boolean f_114368_;

    @Shadow
    private static void m_114422_(PoseStack.Pose entry, VertexConsumer vertices, float alpha, float x, float y, float z, float u, float v) {
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=0, shift=At.Shift.AFTER)})
    private void inject_render_0(Entity entity, double x, double y, double z, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        if (!(entity instanceof Projectile) && !(entity instanceof ExperienceOrb) && EntityTags.allowGravityTransformationInRendering(entity)) {
            Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            if (!this.f_114368_) {
                return;
            }
            matrices.m_85836_();
            RotationAnimation animation = GravityChangerAPI.getRotationAnimation(entity);
            if (animation == null) {
                return;
            }
            long timeMs = entity.m_9236_().m_46467_() * 50L + (long)(tickDelta * 50.0f);
            matrices.m_252781_(new Quaternionf((Quaternionfc)animation.getCurrentGravityRotation(gravityDirection, timeMs)).conjugate());
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=1)})
    private void inject_render_1(Entity entity, double x, double y, double z, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        if (!(entity instanceof Projectile) && !(entity instanceof ExperienceOrb) && EntityTags.allowGravityTransformationInRendering(entity)) {
            Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            if (!this.f_114368_) {
                return;
            }
            matrices.m_85849_();
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=1, shift=At.Shift.AFTER)})
    private void inject_render_2(Entity entity, double x, double y, double z, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        if (!(entity instanceof Projectile) && !(entity instanceof ExperienceOrb) && EntityTags.allowGravityTransformationInRendering(entity)) {
            Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            if (gravityDirection == Direction.DOWN) {
                return;
            }
            if (!this.f_114368_) {
                return;
            }
            matrices.m_252781_(RotationUtil.getCameraRotationQuaternion(gravityDirection));
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;renderShadow(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/Entity;FFLnet/minecraft/world/level/LevelReader;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void inject_renderShadow(PoseStack matrices, MultiBufferSource vertexConsumers, Entity entity, float opacity, float tickDelta, LevelReader world, float radius, CallbackInfo ci) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        double x = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_());
        Vec3 minShadowPos = RotationUtil.vecPlayerToWorld((double)(-radius), (double)(-radius), (double)(-radius), gravityDirection).m_82520_(x, y, z);
        Vec3 maxShadowPos = RotationUtil.vecPlayerToWorld((double)radius, 0.0, (double)radius, gravityDirection).m_82520_(x, y, z);
        PoseStack.Pose entry = matrices.m_85850_();
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(f_114361_);
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)BlockPos.m_274446_((Position)minShadowPos), (BlockPos)BlockPos.m_274446_((Position)maxShadowPos))) {
            EntityRenderDispatcherMixin.gravitychanger$renderShadowPartPlayer(entry, vertexConsumer, world, blockPos, x, y, z, radius, opacity, gravityDirection);
        }
    }

    private static void gravitychanger$renderShadowPartPlayer(PoseStack.Pose entry, VertexConsumer vertices, LevelReader world, BlockPos pos, double x, double y, double z, float radius, float opacity, Direction gravityDirection) {
        VoxelShape voxelShape;
        BlockPos posBelow = pos.m_121945_(gravityDirection);
        BlockState blockStateBelow = world.m_8055_(posBelow);
        if (blockStateBelow.m_60799_() != RenderShape.INVISIBLE && world.m_46803_(pos) > 3 && blockStateBelow.m_60838_((BlockGetter)world, posBelow) && !(voxelShape = blockStateBelow.m_60808_((BlockGetter)world, posBelow)).m_83281_()) {
            Vec3 playerPos = RotationUtil.vecWorldToPlayer(x, y, z, gravityDirection);
            float alpha = (float)(((double)opacity - (playerPos.f_82480_ - (RotationUtil.vecWorldToPlayer((Vec3)Vec3.m_82512_((Vec3i)pos), (Direction)gravityDirection).f_82480_ - 0.5)) / 2.0) * 0.5 * (double)world.m_220417_(pos));
            if (alpha >= 0.0f) {
                if (alpha > 1.0f) {
                    alpha = 1.0f;
                }
                Vec3 centerPos = Vec3.m_82512_((Vec3i)pos);
                Vec3 playerCenterPos = RotationUtil.vecWorldToPlayer(centerPos, gravityDirection);
                Vec3 playerRelNN = playerCenterPos.m_82520_(-0.5, -0.5, -0.5).m_82546_(playerPos);
                Vec3 playerRelPP = playerCenterPos.m_82520_(0.5, -0.5, 0.5).m_82546_(playerPos);
                Vec3 relNN = RotationUtil.vecWorldToPlayer(centerPos.m_82549_(RotationUtil.vecPlayerToWorld(-0.5, -0.5, -0.5, gravityDirection)).m_82492_(x, y, z), gravityDirection);
                Vec3 relNP = RotationUtil.vecWorldToPlayer(centerPos.m_82549_(RotationUtil.vecPlayerToWorld(-0.5, -0.5, 0.5, gravityDirection)).m_82492_(x, y, z), gravityDirection);
                Vec3 relPN = RotationUtil.vecWorldToPlayer(centerPos.m_82549_(RotationUtil.vecPlayerToWorld(0.5, -0.5, -0.5, gravityDirection)).m_82492_(x, y, z), gravityDirection);
                Vec3 relPP = RotationUtil.vecWorldToPlayer(centerPos.m_82549_(RotationUtil.vecPlayerToWorld(0.5, -0.5, 0.5, gravityDirection)).m_82492_(x, y, z), gravityDirection);
                float minU = -((float)playerRelNN.f_82479_) / 2.0f / radius + 0.5f;
                float maxU = -((float)playerRelPP.f_82479_) / 2.0f / radius + 0.5f;
                float minV = -((float)playerRelNN.f_82481_) / 2.0f / radius + 0.5f;
                float maxV = -((float)playerRelPP.f_82481_) / 2.0f / radius + 0.5f;
                EntityRenderDispatcherMixin.m_114422_(entry, vertices, alpha, (float)relNN.f_82479_, (float)relNN.f_82480_, (float)relNN.f_82481_, minU, minV);
                EntityRenderDispatcherMixin.m_114422_(entry, vertices, alpha, (float)relNP.f_82479_, (float)relNP.f_82480_, (float)relNP.f_82481_, minU, maxV);
                EntityRenderDispatcherMixin.m_114422_(entry, vertices, alpha, (float)relPP.f_82479_, (float)relPP.f_82480_, (float)relPP.f_82481_, maxU, maxV);
                EntityRenderDispatcherMixin.m_114422_(entry, vertices, alpha, (float)relPN.f_82479_, (float)relPN.f_82480_, (float)relPN.f_82481_, maxU, minV);
            }
        }
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;F)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), ordinal=0)
    private static AABB modify_renderHitbox_Box_0(AABB box, PoseStack matrices, VertexConsumer vertices, Entity entity, float tickDelta) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return box;
        }
        return RotationUtil.boxWorldToPlayer(box, gravityDirection);
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private static Vec3 redirectViewVector(Entity instance, float partialTicks) {
        Vec3 viewVector = instance.m_20252_(partialTicks);
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(instance);
        if (gravityDirection == Direction.DOWN) {
            return viewVector;
        }
        return RotationUtil.vecWorldToPlayer(viewVector, gravityDirection);
    }
}

