/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.mob_effect;

import com.min01.gravityapi.capabilities.GravityCapabilityImpl;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class GravityStrengthMobEffect
extends MobEffect {
    public final double base;
    public final int signum;

    public GravityStrengthMobEffect(int color, double base, int signum) {
        super(MobEffectCategory.NEUTRAL, color);
        this.base = base;
        this.signum = signum;
    }

    public double getGravityStrengthMultiplier(int level) {
        return Math.pow(this.base, level) * (double)this.signum;
    }

    public void apply(LivingEntity entity, GravityCapabilityImpl component) {
        MobEffectInstance effectInstance = entity.m_21124_((MobEffect)this);
        if (effectInstance == null) {
            return;
        }
        int level = effectInstance.m_19564_() + 1;
        component.applyGravityStrengthEffect(this.getGravityStrengthMultiplier(level));
    }
}

