/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.plating;

import com.min01.gravityapi.init.GravityItems;
import com.min01.gravityapi.plating.GravityPlatingBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class GravityPlatingItem
extends BlockItem {
    public GravityPlatingItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    public static GravityPlatingBlockEntity.SideData getSideData(@Nullable CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        if (tag.m_128441_("sideData")) {
            CompoundTag t = tag.m_128469_("sideData");
            return GravityPlatingBlockEntity.SideData.fromTag(t);
        }
        return null;
    }

    public static void setSideData(CompoundTag tag, @Nullable GravityPlatingBlockEntity.SideData sideData) {
        if (sideData != null) {
            tag.m_128365_("sideData", (Tag)sideData.toTag());
        } else {
            tag.m_128473_("sideData");
        }
    }

    public static ItemStack createStack(@Nullable GravityPlatingBlockEntity.SideData sideData) {
        ItemStack itemStack = new ItemStack((ItemLike)GravityItems.GRAVITY_PLATING.get());
        GravityPlatingItem.setSideData(itemStack.m_41784_(), sideData);
        return itemStack;
    }

    public Component m_7626_(ItemStack stack) {
        GravityPlatingBlockEntity.SideData sideData = GravityPlatingItem.getSideData(stack.m_41783_());
        if (sideData != null) {
            return Component.m_237110_((String)"gravity_changer.plating.item_name", (Object[])new Object[]{sideData.level, GravityPlatingBlockEntity.getForceText(sideData.isAttracting)});
        }
        return super.m_7626_(stack);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        BlockEntity blockEntity;
        InteractionResult result = super.m_40576_(context);
        Level level = context.m_43725_();
        ItemStack itemStack = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        if (level.m_5776_()) {
            return result;
        }
        GravityPlatingBlockEntity.SideData sideData = GravityPlatingItem.getSideData(itemStack.m_41784_());
        if (sideData != null && (blockEntity = level.m_7702_(clickedPos)) instanceof GravityPlatingBlockEntity) {
            GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
            be.onPlacing(context.m_43719_().m_122424_(), sideData);
        }
        return result;
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"gravity_changer.plating.tooltip.0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"gravity_changer.plating.tooltip.1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"gravity_changer.plating.tooltip.2").m_130940_(ChatFormatting.GRAY));
    }
}

