/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.util;

import com.min01.gravityapi.util.QuaternionUtil;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class RotationUtil {
    private static final Direction[][] DIR_WORLD_TO_PLAYER;
    private static final Direction[][] DIR_PLAYER_TO_WORLD;
    private static final Quaternionf[] WORLD_ROTATION_QUATERNIONS;
    private static final Quaternionf[] ENTITY_ROTATION_QUATERNIONS;

    public static Direction dirWorldToPlayer(Direction direction, Direction gravityDirection) {
        return DIR_WORLD_TO_PLAYER[gravityDirection.m_122411_()][direction.m_122411_()];
    }

    public static Direction dirPlayerToWorld(Direction direction, Direction gravityDirection) {
        return DIR_PLAYER_TO_WORLD[gravityDirection.m_122411_()][direction.m_122411_()];
    }

    public static Vec3 vecWorldToPlayer(double x, double y, double z, Direction gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(x, y, z);
            case Direction.UP -> new Vec3(-x, -y, z);
            case Direction.NORTH -> new Vec3(x, z, -y);
            case Direction.SOUTH -> new Vec3(-x, -z, -y);
            case Direction.WEST -> new Vec3(-z, x, -y);
            case Direction.EAST -> new Vec3(z, -x, -y);
        };
    }

    public static Vec3 vecWorldToPlayer(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.vecWorldToPlayer(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, gravityDirection);
    }

    public static Vec3 vecEntityToWorld(double x, double y, double z, Direction gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(x, y, z);
            case Direction.UP -> new Vec3(x, -y, z);
            case Direction.NORTH -> new Vec3(x, -z, y);
            case Direction.SOUTH -> new Vec3(-x, -z, -y);
            case Direction.WEST -> new Vec3(y, -z, -x);
            case Direction.EAST -> new Vec3(-y, -z, x);
        };
    }

    public static Vec3 vecEntityToWorld(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.vecEntityToWorld(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, gravityDirection);
    }

    public static Vec3 vecPlayerToWorld(double x, double y, double z, Direction gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(x, y, z);
            case Direction.UP -> new Vec3(-x, -y, z);
            case Direction.NORTH -> new Vec3(x, -z, y);
            case Direction.SOUTH -> new Vec3(-x, -z, -y);
            case Direction.WEST -> new Vec3(y, -z, -x);
            case Direction.EAST -> new Vec3(-y, -z, x);
        };
    }

    public static Vec3 vecPlayerToWorld(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.vecPlayerToWorld(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, gravityDirection);
    }

    public static Vector3f vecWorldToPlayer(float x, float y, float z, Direction gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vector3f(x, y, z);
            case Direction.UP -> new Vector3f(-x, -y, z);
            case Direction.NORTH -> new Vector3f(x, z, -y);
            case Direction.SOUTH -> new Vector3f(-x, -z, -y);
            case Direction.WEST -> new Vector3f(-z, x, -y);
            case Direction.EAST -> new Vector3f(z, -x, -y);
        };
    }

    public static Vector3f vecWorldToPlayer(Vector3f vector3F, Direction gravityDirection) {
        return RotationUtil.vecWorldToPlayer(vector3F.x(), vector3F.y(), vector3F.z(), gravityDirection);
    }

    public static Vector3f vecPlayerToWorld(float x, float y, float z, Direction gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vector3f(x, y, z);
            case Direction.UP -> new Vector3f(-x, -y, z);
            case Direction.NORTH -> new Vector3f(x, -z, y);
            case Direction.SOUTH -> new Vector3f(-x, -z, -y);
            case Direction.WEST -> new Vector3f(y, -z, -x);
            case Direction.EAST -> new Vector3f(-y, -z, x);
        };
    }

    public static Vector3f vecPlayerToWorld(Vector3f vector3F, Direction gravityDirection) {
        return RotationUtil.vecPlayerToWorld(vector3F.x(), vector3F.y(), vector3F.z(), gravityDirection);
    }

    public static Vec3 maskWorldToPlayer(double x, double y, double z, Direction gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> new Vec3(x, y, z);
            case Direction.NORTH, Direction.SOUTH -> new Vec3(x, z, y);
            case Direction.WEST, Direction.EAST -> new Vec3(z, x, y);
        };
    }

    public static Vec3 maskWorldToPlayer(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.maskWorldToPlayer(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, gravityDirection);
    }

    public static Vec3 maskPlayerToWorld(double x, double y, double z, Direction gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> new Vec3(x, y, z);
            case Direction.NORTH, Direction.SOUTH -> new Vec3(x, z, y);
            case Direction.WEST, Direction.EAST -> new Vec3(y, z, x);
        };
    }

    public static Vec3 maskPlayerToWorld(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.maskPlayerToWorld(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, gravityDirection);
    }

    public static AABB boxWorldToPlayer(AABB box, Direction gravityDirection) {
        return new AABB(RotationUtil.vecWorldToPlayer(box.f_82288_, box.f_82289_, box.f_82290_, gravityDirection), RotationUtil.vecWorldToPlayer(box.f_82291_, box.f_82292_, box.f_82293_, gravityDirection));
    }

    public static AABB boxPlayerToWorld(AABB box, Direction gravityDirection) {
        return new AABB(RotationUtil.vecPlayerToWorld(box.f_82288_, box.f_82289_, box.f_82290_, gravityDirection), RotationUtil.vecPlayerToWorld(box.f_82291_, box.f_82292_, box.f_82293_, gravityDirection));
    }

    public static Vec2 rotWorldToPlayer(float yaw, float pitch, Direction gravityDirection) {
        Vec3 vec3d = RotationUtil.vecWorldToPlayer(RotationUtil.rotToVec(yaw, pitch), gravityDirection);
        return RotationUtil.vecToRot(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public static Vec2 rotWorldToPlayer(Vec2 vec2f, Direction gravityDirection) {
        return RotationUtil.rotWorldToPlayer(vec2f.f_82470_, vec2f.f_82471_, gravityDirection);
    }

    public static Vec2 rotPlayerToWorld(float yaw, float pitch, Direction gravityDirection) {
        Vec3 vec3d = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(yaw, pitch), gravityDirection);
        return RotationUtil.vecToRot(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public static Vec2 rotPlayerToWorld(Vec2 vec2f, Direction gravityDirection) {
        return RotationUtil.rotPlayerToWorld(vec2f.f_82470_, vec2f.f_82471_, gravityDirection);
    }

    public static Vec3 rotToVec(float yaw, float pitch) {
        double radPitch = (double)pitch * 0.017453292;
        double radNegYaw = (double)(-yaw) * 0.017453292;
        double cosNegYaw = Math.cos(radNegYaw);
        double sinNegYaw = Math.sin(radNegYaw);
        double cosPitch = Math.cos(radPitch);
        double sinPitch = Math.sin(radPitch);
        return new Vec3(sinNegYaw * cosPitch, -sinPitch, cosNegYaw * cosPitch);
    }

    public static Vec2 vecToRot(double x, double y, double z) {
        double sinPitch = -y;
        double radPitch = Math.asin(sinPitch);
        double cosPitch = Math.cos(radPitch);
        double sinNegYaw = x / cosPitch;
        double cosNegYaw = Mth.m_14008_((double)(z / cosPitch), (double)-1.0, (double)1.0);
        double radNegYaw = Math.acos(cosNegYaw);
        if (sinNegYaw < 0.0) {
            radNegYaw = Math.PI * 2 - radNegYaw;
        }
        return new Vec2(Mth.m_14177_((float)((float)(-radNegYaw) / ((float)Math.PI / 180))), (float)radPitch / ((float)Math.PI / 180));
    }

    public static Vec2 vecToRot(Vec3 vec3d) {
        return RotationUtil.vecToRot(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public static Quaternionf getWorldRotationQuaternion(Direction gravityDirection) {
        return WORLD_ROTATION_QUATERNIONS[gravityDirection.m_122411_()];
    }

    public static Quaternionf getCameraRotationQuaternion(Direction gravityDirection) {
        return ENTITY_ROTATION_QUATERNIONS[gravityDirection.m_122411_()];
    }

    public static Quaternionf getRotationBetween(Direction d1, Direction d2) {
        Vec3 start = new Vec3(d1.m_253071_());
        Vec3 end = new Vec3(d2.m_253071_());
        if (d1.m_122424_() == d2) {
            return new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), 180.0f);
        }
        return QuaternionUtil.getRotationBetween(start, end);
    }

    public static Quaternionf interpolate(Quaternionf startGravityRotation, Quaternionf endGravityRotation, float progress) {
        return new Quaternionf().set((Quaternionfc)startGravityRotation).slerp((Quaternionfc)endGravityRotation, progress);
    }

    public static AABB makeBoxFromDimensions(EntityDimensions dimensions, Direction gravityDir, Vec3 pos) {
        AABB rawBox = dimensions.m_20384_(0.0, 0.0, 0.0);
        return RotationUtil.boxPlayerToWorld(rawBox, gravityDir).m_82383_(pos);
    }

    static {
        Vec3 directionVector;
        DIR_WORLD_TO_PLAYER = new Direction[6][];
        for (Direction gravityDirection : Direction.values()) {
            RotationUtil.DIR_WORLD_TO_PLAYER[gravityDirection.m_122411_()] = new Direction[6];
            for (Direction direction : Direction.values()) {
                directionVector = Vec3.m_82528_((Vec3i)direction.m_122436_());
                directionVector = RotationUtil.vecWorldToPlayer(directionVector, gravityDirection);
                RotationUtil.DIR_WORLD_TO_PLAYER[gravityDirection.m_122411_()][direction.m_122411_()] = Direction.m_122366_((double)directionVector.f_82479_, (double)directionVector.f_82480_, (double)directionVector.f_82481_);
            }
        }
        DIR_PLAYER_TO_WORLD = new Direction[6][];
        for (Direction gravityDirection : Direction.values()) {
            RotationUtil.DIR_PLAYER_TO_WORLD[gravityDirection.m_122411_()] = new Direction[6];
            for (Direction direction : Direction.values()) {
                directionVector = Vec3.m_82528_((Vec3i)direction.m_122436_());
                directionVector = RotationUtil.vecPlayerToWorld(directionVector, gravityDirection);
                RotationUtil.DIR_PLAYER_TO_WORLD[gravityDirection.m_122411_()][direction.m_122411_()] = Direction.m_122366_((double)directionVector.f_82479_, (double)directionVector.f_82480_, (double)directionVector.f_82481_);
            }
        }
        WORLD_ROTATION_QUATERNIONS = new Quaternionf[6];
        RotationUtil.WORLD_ROTATION_QUATERNIONS[0] = new Quaternionf();
        RotationUtil.WORLD_ROTATION_QUATERNIONS[1] = Axis.f_252403_.m_252977_(-180.0f);
        RotationUtil.WORLD_ROTATION_QUATERNIONS[2] = Axis.f_252529_.m_252977_(-90.0f);
        RotationUtil.WORLD_ROTATION_QUATERNIONS[3] = Axis.f_252529_.m_252977_(-90.0f);
        WORLD_ROTATION_QUATERNIONS[3].mul((Quaternionfc)Axis.f_252436_.m_252977_(-180.0f));
        RotationUtil.WORLD_ROTATION_QUATERNIONS[4] = Axis.f_252529_.m_252977_(-90.0f);
        WORLD_ROTATION_QUATERNIONS[4].mul((Quaternionfc)Axis.f_252436_.m_252977_(-90.0f));
        RotationUtil.WORLD_ROTATION_QUATERNIONS[5] = Axis.f_252529_.m_252977_(-90.0f);
        WORLD_ROTATION_QUATERNIONS[5].mul((Quaternionfc)Axis.f_252436_.m_252977_(-270.0f));
        ENTITY_ROTATION_QUATERNIONS = new Quaternionf[6];
        for (int i = 0; i < 6; ++i) {
            RotationUtil.ENTITY_ROTATION_QUATERNIONS[i] = new Quaternionf().set((Quaternionfc)WORLD_ROTATION_QUATERNIONS[i]).conjugate();
        }
    }
}

