/*
 * Decompiled with CFR 0.152.
 */
package com.example.commanditem.client;

import com.example.commanditem.client.KeyBinds;
import com.example.commanditem.config.ClientConfig;
import com.example.commanditem.gui.CommandMenuScreen;
import com.example.commanditem.storage.CommandStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    private static final Map<String, Long> autoCommandTimers = new HashMap<String, Long>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Map<String, List<ScheduledFuture<?>>> scheduledCommands = new HashMap();

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (KeyBinds.openMenuKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new CommandMenuScreen());
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        boolean useLeftClick;
        ClientPlayerEntity player;
        ItemStack stack;
        if (event.getSide().isClient() && Minecraft.func_71410_x().field_71462_r == null && !(stack = (player = Minecraft.func_71410_x().field_71439_g).func_184614_ca()).func_190926_b() && ((useLeftClick = ((Boolean)ClientConfig.USE_LEFT_CLICK.get()).booleanValue()) && event instanceof PlayerInteractEvent.LeftClickEmpty || !useLeftClick && event instanceof PlayerInteractEvent.RightClickEmpty)) {
            ClientEventHandler.executeSequenceCommandsForItem(stack, player);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null) {
            ClientEventHandler.checkAutoCommands();
        }
    }

    private static void executeSequenceCommandsForItem(ItemStack stack, ClientPlayerEntity player) {
        String itemKey = stack.toString();
        ClientEventHandler.cancelScheduledCommands(itemKey);
        List<String> commands = CommandStorage.getCommandsForItem(stack);
        ArrayList<SequenceCommand> sequenceCommands = new ArrayList<SequenceCommand>();
        long totalDelay = 0L;
        for (String command : commands) {
            String[] parts;
            if (!command.startsWith("[SEQUENCE]") || (parts = command.split(" \\| ", 2)).length < 2) continue;
            String delayPart = parts[0].substring(11);
            String cleanCommand = parts[1];
            long delay = ClientEventHandler.parseDelay(delayPart);
            sequenceCommands.add(new SequenceCommand(cleanCommand, totalDelay + delay));
            totalDelay += delay;
        }
        for (SequenceCommand seqCmd : sequenceCommands) {
            ScheduledFuture<?> future = scheduler.schedule(() -> {
                if (player.func_70089_S() && player.func_184614_ca().equals(stack)) {
                    player.func_71165_d(seqCmd.command);
                }
            }, seqCmd.delay, TimeUnit.MILLISECONDS);
            scheduledCommands.computeIfAbsent(itemKey, k -> new ArrayList()).add(future);
        }
    }

    private static void cancelScheduledCommands(String itemKey) {
        List<ScheduledFuture<?>> futures = scheduledCommands.get(itemKey);
        if (futures != null) {
            for (ScheduledFuture<?> future : futures) {
                future.cancel(false);
            }
            futures.clear();
        }
    }

    private static void checkAutoCommands() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        List<String> commands = CommandStorage.getCommandsForItem(stack);
        long currentTime = System.currentTimeMillis();
        for (String command : commands) {
            if (!command.startsWith("[AUTO]")) continue;
            String commandKey = stack.toString() + command;
            if (!autoCommandTimers.containsKey(commandKey)) {
                autoCommandTimers.put(commandKey, currentTime);
                continue;
            }
            long lastExecution = autoCommandTimers.get(commandKey);
            String[] parts = command.split(" \\| ", 2);
            if (parts.length < 2) continue;
            String delayPart = parts[0].substring(7);
            String cleanCommand = parts[1];
            long delay = ClientEventHandler.parseDelay(delayPart);
            if (currentTime - lastExecution < delay) continue;
            player.func_71165_d(cleanCommand);
            autoCommandTimers.put(commandKey, currentTime);
        }
    }

    private static long parseDelay(String delayStr) {
        try {
            delayStr = delayStr.toLowerCase().trim();
            if (delayStr.endsWith("min")) {
                String numberStr = delayStr.replace("min", "").trim();
                double minutes = Double.parseDouble(numberStr);
                return (long)(minutes * 60.0 * 1000.0);
            }
            if (delayStr.endsWith("sec")) {
                String numberStr = delayStr.replace("sec", "").trim();
                double seconds = Double.parseDouble(numberStr);
                return (long)(seconds * 1000.0);
            }
            if (delayStr.endsWith("s")) {
                String numberStr = delayStr.replace("s", "").trim();
                double seconds = Double.parseDouble(numberStr);
                return (long)(seconds * 1000.0);
            }
            double seconds = Double.parseDouble(delayStr);
            return (long)(seconds * 1000.0);
        }
        catch (NumberFormatException e) {
            return 1000L;
        }
    }

    private static class SequenceCommand {
        final String command;
        final long delay;

        SequenceCommand(String command, long delay) {
            this.command = command;
            this.delay = delay;
        }
    }
}

