/*
 * Decompiled with CFR 0.152.
 */
package com.example.commanditem.gui;

import com.example.commanditem.storage.CommandStorage;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CommandMenuScreen
extends Screen {
    private TextFieldWidget commandField;
    private TextFieldWidget delayField;
    private Button addButton;
    private Button saveButton;
    private Button cancelButton;
    private List<String> commands = new ArrayList<String>();
    private List<Button> deleteButtons = new ArrayList<Button>();
    private List<Button> upButtons = new ArrayList<Button>();
    private List<Button> downButtons = new ArrayList<Button>();
    private ItemStack currentItem;
    private int currentTab = 0;
    private int currentPage = 0;
    private static final int COMMANDS_PER_PAGE = 8;

    public CommandMenuScreen() {
        super((ITextComponent)new StringTextComponent("Command Menu"));
        this.currentItem = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (!this.currentItem.func_190926_b()) {
            this.commands = CommandStorage.getCommandsForItem(this.currentItem);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int centerX = this.field_230708_k_ / 2;
        Button sequenceTab = new Button(centerX - 100, 40, 90, 20, (ITextComponent)new StringTextComponent("Sequence"), button -> this.switchTab(0));
        Button autoTab = new Button(centerX, 40, 90, 20, (ITextComponent)new StringTextComponent("Auto"), button -> this.switchTab(1));
        this.func_230480_a_((Widget)sequenceTab);
        this.func_230480_a_((Widget)autoTab);
        this.commandField = new TextFieldWidget(this.field_230712_o_, centerX - 150, 100, 250, 20, (ITextComponent)new StringTextComponent("Command"));
        this.commandField.func_146203_f(256);
        this.field_230705_e_.add(this.commandField);
        this.delayField = new TextFieldWidget(this.field_230712_o_, centerX + 110, 100, 40, 20, (ITextComponent)new StringTextComponent("Delay"));
        this.delayField.func_146203_f(10);
        this.delayField.func_146180_a("0s");
        this.field_230705_e_.add(this.delayField);
        this.addButton = new Button(centerX - 150, 125, 150, 20, (ITextComponent)new StringTextComponent("Add Command"), button -> this.addCommand());
        this.saveButton = new Button(centerX - 50, this.field_230709_l_ - 30, 100, 20, (ITextComponent)new StringTextComponent("Save"), button -> this.saveAndClose());
        this.cancelButton = new Button(centerX + 50, this.field_230709_l_ - 30, 100, 20, (ITextComponent)new StringTextComponent("Cancel"), button -> this.field_230706_i_.func_147108_a(null));
        this.func_230480_a_((Widget)this.addButton);
        this.func_230480_a_((Widget)this.saveButton);
        this.func_230480_a_((Widget)this.cancelButton);
        this.func_212928_a((IGuiEventListener)this.commandField);
        this.updateActionButtons();
        this.updateTabDisplay();
    }

    private void switchTab(int tab) {
        this.currentTab = tab;
        this.currentPage = 0;
        this.updateTabDisplay();
    }

    private void updateTabDisplay() {
        if (this.currentTab == 0) {
            this.delayField.func_146180_a("0s");
            this.addButton.func_238482_a_((ITextComponent)new StringTextComponent("Add Sequence Cmd"));
        } else {
            this.delayField.func_146180_a("5sec");
            this.addButton.func_238482_a_((ITextComponent)new StringTextComponent("Add Auto Cmd"));
        }
        this.updateActionButtons();
    }

    private void addCommand() {
        String command = this.commandField.func_146179_b().trim();
        String delay = this.delayField.func_146179_b().trim();
        if (!command.isEmpty()) {
            if (delay.isEmpty()) {
                delay = this.currentTab == 0 ? "0s" : "5sec";
            }
            String prefix = this.currentTab == 0 ? "[SEQUENCE]" : "[AUTO]";
            this.commands.add(prefix + " " + delay + " | " + command);
            this.commandField.func_146180_a("");
            int totalPages = (int)Math.ceil((double)this.commands.size() / 8.0);
            this.currentPage = Math.max(0, totalPages - 1);
            this.updateActionButtons();
        }
    }

    private void updateActionButtons() {
        for (Button button2 : this.deleteButtons) {
            this.field_230710_m_.remove(button2);
            this.field_230705_e_.remove(button2);
        }
        for (Button button2 : this.upButtons) {
            this.field_230710_m_.remove(button2);
            this.field_230705_e_.remove(button2);
        }
        for (Button button2 : this.downButtons) {
            this.field_230710_m_.remove(button2);
            this.field_230705_e_.remove(button2);
        }
        this.deleteButtons.clear();
        this.upButtons.clear();
        this.downButtons.clear();
        int listStartY = 180;
        int startIndex = this.currentPage * 8;
        int endIndex = Math.min(startIndex + 8, this.commands.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int index = i;
            int displayIndex = i - startIndex;
            int yPos = listStartY + displayIndex * 15;
            Button deleteButton = new Button(this.field_230708_k_ / 2 + 160, yPos, 20, 14, (ITextComponent)new StringTextComponent("X"), button -> this.deleteCommand(index));
            this.func_230480_a_((Widget)deleteButton);
            this.deleteButtons.add(deleteButton);
            Button upButton = new Button(this.field_230708_k_ / 2 + 185, yPos, 14, 14, (ITextComponent)new StringTextComponent("+"), button -> this.moveCommandUp(index));
            this.func_230480_a_((Widget)upButton);
            this.upButtons.add(upButton);
            Button downButton = new Button(this.field_230708_k_ / 2 + 204, yPos, 14, 14, (ITextComponent)new StringTextComponent("-"), button -> this.moveCommandDown(index));
            this.func_230480_a_((Widget)downButton);
            this.downButtons.add(downButton);
            if (index == 0) {
                upButton.field_230693_o_ = false;
            }
            if (index != this.commands.size() - 1) continue;
            downButton.field_230693_o_ = false;
        }
        int totalPages = (int)Math.ceil((double)this.commands.size() / 8.0);
        if (totalPages > 1) {
            Button prevPageButton = new Button(this.field_230708_k_ / 2 - 180, listStartY + 120 + 10, 40, 16, (ITextComponent)new StringTextComponent("< Back"), button -> {
                if (this.currentPage > 0) {
                    --this.currentPage;
                    this.updateActionButtons();
                }
            });
            this.func_230480_a_((Widget)prevPageButton);
            Button nextPageButton = new Button(this.field_230708_k_ / 2 - 130, listStartY + 120 + 10, 40, 16, (ITextComponent)new StringTextComponent("Next >"), button -> {
                if (this.currentPage < totalPages - 1) {
                    ++this.currentPage;
                    this.updateActionButtons();
                }
            });
            this.func_230480_a_((Widget)nextPageButton);
            String pageInfo = "Page " + (this.currentPage + 1) + "/" + totalPages;
            this.field_230712_o_.func_238421_b_(new MatrixStack(), pageInfo, (float)(this.field_230708_k_ / 2 - 80), (float)(listStartY + 120 + 14), 0xFFFFFF);
        }
    }

    private void deleteCommand(int index) {
        if (index >= 0 && index < this.commands.size()) {
            this.commands.remove(index);
            int totalPages = (int)Math.ceil((double)this.commands.size() / 8.0);
            if (this.currentPage >= totalPages && totalPages > 0) {
                this.currentPage = totalPages - 1;
            }
            this.updateActionButtons();
        }
    }

    private void moveCommandUp(int index) {
        if (index > 0 && index < this.commands.size()) {
            String temp = this.commands.get(index - 1);
            this.commands.set(index - 1, this.commands.get(index));
            this.commands.set(index, temp);
            this.updateActionButtons();
        }
    }

    private void moveCommandDown(int index) {
        if (index >= 0 && index < this.commands.size() - 1) {
            String temp = this.commands.get(index + 1);
            this.commands.set(index + 1, this.commands.get(index));
            this.commands.set(index, temp);
            this.updateActionButtons();
        }
    }

    private void saveAndClose() {
        if (!this.currentItem.func_190926_b()) {
            CommandStorage.saveCommandsForItem(this.currentItem, this.commands);
        }
        this.field_230706_i_.func_147108_a(null);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        CommandMenuScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Command Menu", (int)(this.field_230708_k_ / 2), (int)15, (int)0xFFFFFF);
        if (!this.currentItem.func_190926_b()) {
            String itemName = this.currentItem.func_200301_q().getString();
            if (itemName.length() > 25) {
                itemName = itemName.substring(0, 22) + "...";
            }
            CommandMenuScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("Item: " + itemName), (int)(this.field_230708_k_ / 2), (int)25, (int)0xAAAAAA);
        }
        String modeText = this.currentTab == 0 ? "Sequence Commands (with delays)" : "Auto Commands (while holding)";
        CommandMenuScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)modeText, (int)(this.field_230708_k_ / 2), (int)70, (int)0xFFFFFF);
        this.field_230712_o_.func_238421_b_(matrixStack, "Command:", (float)(this.field_230708_k_ / 2 - 150), 90.0f, 0xAAAAAA);
        this.field_230712_o_.func_238421_b_(matrixStack, this.currentTab == 0 ? "Delay:" : "Interval:", (float)(this.field_230708_k_ / 2 + 110), 90.0f, 0xAAAAAA);
        String formatHint = this.currentTab == 0 ? "Format: 0s, 1.5s, 2s" : "Format: 5sec, 1min, 0.5sec";
        this.field_230712_o_.func_238421_b_(matrixStack, formatHint, (float)(this.field_230708_k_ / 2 - 150), 150.0f, 0xAAAAAA);
        this.commandField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.delayField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int listStartY = 180;
        this.field_230712_o_.func_238421_b_(matrixStack, "Command List:", (float)(this.field_230708_k_ / 2 - 150), (float)(listStartY - 15), 0xFFFF00);
        int startIndex = this.currentPage * 8;
        int endIndex = Math.min(startIndex + 8, this.commands.size());
        for (int i = startIndex; i < endIndex; ++i) {
            String command = this.commands.get(i);
            int color = command.startsWith("[AUTO]") ? 65280 : 0xFFFFFF;
            String displayText = i + 1 + ": " + command;
            if (displayText.length() > 45) {
                displayText = displayText.substring(0, 42) + "...";
            }
            int displayIndex = i - startIndex;
            this.field_230712_o_.func_238421_b_(matrixStack, displayText, (float)(this.field_230708_k_ / 2 - 150), (float)(listStartY + displayIndex * 15), color);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.commandField.func_231042_a_(codePoint, modifiers) || this.delayField.func_231042_a_(codePoint, modifiers)) {
            return true;
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        if (this.commandField.func_231046_a_(keyCode, scanCode, modifiers) || this.delayField.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.commandField.func_231044_a_(mouseX, mouseY, button);
        this.delayField.func_231044_a_(mouseX, mouseY, button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }
}

