/*
 * Decompiled with CFR 0.152.
 */
package com.example.commanditem.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class CommandStorage {
    private static final Map<String, List<String>> itemCommands = new HashMap<String, List<String>>();

    public static void saveCommandsForItem(ItemStack stack, List<String> commands) {
        String key = CommandStorage.getItemKey(stack);
        if (commands.isEmpty()) {
            itemCommands.remove(key);
        } else {
            itemCommands.put(key, new ArrayList<String>(commands));
        }
    }

    public static List<String> getCommandsForItem(ItemStack stack) {
        String key = CommandStorage.getItemKey(stack);
        return itemCommands.getOrDefault(key, new ArrayList());
    }

    private static String getItemKey(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString() + ":" + stack.func_77978_p();
    }

    public static CompoundNBT saveToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT commandsList = new ListNBT();
        for (Map.Entry<String, List<String>> entry : itemCommands.entrySet()) {
            CompoundNBT entryNBT = new CompoundNBT();
            entryNBT.func_74778_a("itemKey", entry.getKey());
            ListNBT commandNBTList = new ListNBT();
            for (String command : entry.getValue()) {
                commandNBTList.add((Object)StringNBT.func_229705_a_((String)command));
            }
            entryNBT.func_218657_a("commands", (INBT)commandNBTList);
            commandsList.add((Object)entryNBT);
        }
        nbt.func_218657_a("commandItems", (INBT)commandsList);
        return nbt;
    }

    public static void loadFromNBT(CompoundNBT nbt) {
        itemCommands.clear();
        if (nbt.func_74764_b("commandItems")) {
            ListNBT commandsList = nbt.func_150295_c("commandItems", 10);
            for (int i = 0; i < commandsList.size(); ++i) {
                CompoundNBT entryNBT = commandsList.func_150305_b(i);
                String itemKey = entryNBT.func_74779_i("itemKey");
                ListNBT commandNBTList = entryNBT.func_150295_c("commands", 8);
                ArrayList<String> commands = new ArrayList<String>();
                for (int j = 0; j < commandNBTList.size(); ++j) {
                    commands.add(commandNBTList.func_150307_f(j));
                }
                itemCommands.put(itemKey, commands);
            }
        }
    }
}

