/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.pack_presets.implementation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.justahuman.pack_presets.implementation.PresetCompatibility;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5369;
import net.minecraft.class_5375;
import net.minecraft.class_5489;

public final class PackPreset {
    private final String id;
    private final class_2561 displayName;
    private final class_5489 description;
    private final List<class_3288> packs;
    private final PresetCompatibility compatibility;

    public PackPreset(String id, class_2561 displayName, class_5489 description, List<class_3288> packs) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.packs = packs;
        this.compatibility = new PresetCompatibility(packs);
    }

    public void apply(class_5369 organizer) {
        class_3283 manager = organizer.field_25626;
        Consumer applier = organizer.field_25459;
        manager.method_14447((Collection)this.packs.stream().map(class_3288::method_14463).collect(ImmutableList.toImmutableList()));
        applier.accept(manager);
    }

    public String getId() {
        return this.id;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public class_5489 getDescription() {
        return this.description;
    }

    public List<class_3288> getPacks() {
        return this.packs;
    }

    public PresetCompatibility getCompatibility() {
        return this.compatibility;
    }

    public List<class_2960> getPackIcons(class_5369 organizer) {
        ArrayList<class_2960> icons = new ArrayList<class_2960>();
        for (class_3288 profile : Lists.reverse(this.packs)) {
            class_2960 icon;
            if (icons.size() == 4) break;
            if (profile.method_29483() == ModResourcePackCreator.RESOURCE_PACK_SOURCE || (icon = (class_2960)organizer.field_25785.apply(profile)).equals((Object)class_5375.field_25786)) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            icons.add(class_5375.field_25786);
        }
        return icons;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PackPreset that = (PackPreset)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.packs, that.packs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.description, this.packs);
    }

    public String toString() {
        return "PackPreset[id=" + this.id + ", displayName=" + String.valueOf(this.displayName) + ", description=" + String.valueOf(this.description) + ", packs=" + String.valueOf(this.packs) + "]";
    }
}

