/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.pack_presets.implementation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.justahuman.pack_presets.PackPresets;
import me.justahuman.pack_presets.implementation.PackPreset;
import me.justahuman.pack_presets.screen.CreatePresetScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3283;
import net.minecraft.class_4239;
import net.minecraft.class_5489;
import org.slf4j.Logger;

public class PackPresetProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path directory;
    private final class_3283 manager;

    public PackPresetProvider(Path directory, class_3283 manager) {
        this.directory = directory;
        this.manager = manager;
    }

    public List<PackPreset> getPresets() {
        ArrayList<PackPreset> presets = new ArrayList<PackPreset>();
        try {
            class_4239.method_47525((Path)this.directory);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.directory);){
                for (Path path : stream) {
                    JsonObject json;
                    PackPreset preset;
                    String fileName = path.getFileName().toString();
                    if (!fileName.endsWith(".json")) {
                        LOGGER.warn("Found non-json file in presets directory: {}", (Object)fileName);
                    }
                    if ((preset = this.getPreset(path, json = (JsonObject)PackPresets.GSON.fromJson((Reader)Files.newBufferedReader(path), JsonObject.class))) == null) continue;
                    presets.add(preset);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to list presets in {}", (Object)this.directory, (Object)e);
        }
        return presets;
    }

    private PackPreset getPreset(Path path, JsonObject json) {
        try {
            String id;
            String string = id = json.has("name") ? json.get("name").getAsString() : json.get("id").getAsString();
            if (!CreatePresetScreen.validId(id)) {
                LOGGER.warn("Invalid preset id '{}' of '{}', ignoring", (Object)id, (Object)path);
                return null;
            }
            String displayName = json.get("display_name").getAsString();
            if (!CreatePresetScreen.validDisplayName(displayName)) {
                LOGGER.warn("Invalid preset display name '{}' of '{}', ignoring", (Object)displayName, (Object)path);
                return null;
            }
            String description = json.get("description").getAsString();
            if (!CreatePresetScreen.validDescription(description)) {
                LOGGER.warn("Invalid preset description '{}' of '{}', ignoring", (Object)description, (Object)path);
                return null;
            }
            List<String> packs = json.get("packs").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
            if (packs.isEmpty()) {
                LOGGER.warn("Preset '{}' of '{}' has no packs, ignoring", (Object)id, (Object)path);
                return null;
            }
            return new PackPreset(id, (class_2561)class_2561.method_43470((String)displayName), class_5489.method_61132((class_327)class_310.method_1551().field_1772, (int)257, (int)2, (class_2561[])new class_2561[]{class_2561.method_43470((String)description)}), packs.stream().map(arg_0 -> ((class_3283)this.manager).method_14449(arg_0)).filter(Objects::nonNull).toList());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load preset '{}', ignoring", (Object)path, (Object)e);
            return null;
        }
    }
}

