/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.pack_presets.screen.widget;

import java.util.List;
import java.util.Objects;
import me.justahuman.pack_presets.PackPresets;
import me.justahuman.pack_presets.implementation.PackPreset;
import me.justahuman.pack_presets.implementation.PresetCompatibility;
import me.justahuman.pack_presets.screen.PackPresetsScreen;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_410;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_521;
import net.minecraft.class_5481;
import net.minecraft.class_5489;

public class PresetListWidget
extends class_4280<PresetEntry> {
    private final PackPresetsScreen screen;

    public PresetListWidget(class_310 client, PackPresetsScreen screen, int width, int height) {
        super(client, width, height - 83, 32, 36);
        this.screen = screen;
        this.field_22744 = false;
        Objects.requireNonNull(client.field_1772);
        this.method_25315(false, 0);
    }

    public void refresh() {
        this.method_25396().clear();
        PresetEntry entry = (PresetEntry)this.method_25334();
        String id = entry == null ? "" : entry.getPreset().getId();
        this.method_25313(null);
        for (PackPreset preset : PackPresets.getProvider().getPresets()) {
            PresetEntry presetEntry = new PresetEntry(this.field_22740, this, preset);
            this.method_25396().add(presetEntry);
            if (!preset.getId().equals(id)) continue;
            this.method_25313((class_350.class_351)presetEntry);
        }
    }

    public int method_25322() {
        return this.field_22758;
    }

    protected int method_25329() {
        return this.method_55442() - 6;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        PresetEntry entry = (PresetEntry)this.method_25334();
        if (entry != null && keyCode == 257) {
            entry.apply();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static class PresetEntry
    extends class_4280.class_4281<PresetEntry> {
        protected final class_310 client;
        private final PresetListWidget widget;
        private final PackPreset preset;
        private final class_5481 displayName;
        private final class_5489 description;
        private final class_5481 incompatibleText;
        private final class_5489 compatibilityNotificationText;

        public PresetEntry(class_310 client, PresetListWidget widget, PackPreset preset) {
            this.client = client;
            this.widget = widget;
            this.preset = preset;
            this.displayName = class_521.class_4271.method_31229((class_310)client, (class_2561)preset.getDisplayName());
            this.description = preset.getDescription();
            this.incompatibleText = class_521.class_4271.method_31229((class_310)client, (class_2561)class_521.field_19126);
            this.compatibilityNotificationText = preset.getCompatibility().getNotification();
        }

        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.preset.getDisplayName()});
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            PresetCompatibility compatibility = this.preset.getCompatibility();
            if (!compatibility.isCompatible()) {
                context.method_25294(x - 1, y - 1, x + entryWidth - 3, y + entryHeight + 1, -8978432);
            }
            List<class_2960> icons = this.preset.getPackIcons(this.widget.screen.getOrganizer());
            int width = 32 / icons.size();
            for (int i = 0; i < icons.size(); ++i) {
                class_2960 icon = icons.get(i);
                context.method_25290(icon, x + i * width, y, 0.0f, 0.0f, width, 32, 32, 32);
            }
            class_5481 nameText = this.displayName;
            class_5489 descriptionText = this.description;
            if (Boolean.TRUE.equals(this.client.field_1690.method_42446().method_41753()) || hovered || this.widget.method_25334() == this && this.widget.method_25370()) {
                int relativeX;
                context.method_25294(x, y, x + 32, y + 32, -1601138544);
                if (!compatibility.isCompatible()) {
                    nameText = this.incompatibleText;
                    descriptionText = this.compatibilityNotificationText;
                }
                context.method_52706((relativeX = mouseX - x) < 32 ? class_521.field_45532 : class_521.field_45533, x, y, 32, 32);
            }
            context.method_35720(this.client.field_1772, nameText, x + 32 + 2, y + 1, 0xFFFFFF);
            descriptionText.method_30893(context, x + 32 + 2, y + 12, 10, -8355712);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            double relativeX = mouseX - (double)this.widget.method_25342();
            if (relativeX <= 32.0) {
                this.widget.method_25313(null);
                this.apply();
                return true;
            }
            return false;
        }

        public void apply() {
            PresetCompatibility compatibility = this.preset.getCompatibility();
            if (compatibility.isCompatible()) {
                this.preset.apply(this.widget.screen.getOrganizer());
                return;
            }
            this.client.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    this.preset.apply(this.widget.screen.getOrganizer());
                }
            }, (class_2561)class_2561.method_43471((String)"pack_presets.preset.incompatible.confirm.title"), compatibility.getConfirmMessage()));
        }

        public PackPreset getPreset() {
            return this.preset;
        }
    }
}

