/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.jei;

import com.ic2additions.gui.TransparentDynamicGUI;
import com.ic2additions.init.TesRegistry;
import com.ic2additions.recipes.breeding.BreederReactorRecipesHandler;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.ITeBlock;
import ic2.core.init.Localization;
import ic2.core.recipe.RecipeInputOreDict;
import ic2.jeiIntegration.recipe.machine.DynamicCategory;
import ic2.jeiIntegration.recipe.machine.IORecipeCategory;
import ic2.jeiIntegration.recipe.machine.IORecipeWrapper;
import ic2.jeiIntegration.recipe.machine.IRecipeWrapperGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

@JEIPlugin
public final class JeiBreederReactor
implements IModPlugin {
    public void register(IModRegistry registry) {
        registry.addRecipeClickArea(TransparentDynamicGUI.class, 16, 35, 16, 16, new String[]{TesRegistry.breeding_reactor.getName()});
        BreederReactorCategory category = new BreederReactorCategory(registry.getJeiHelpers().getGuiHelper());
        this.addMachineRecipes(registry, (IORecipeCategory)category, (IRecipeWrapperGenerator)BreederReactorRecipeWrapper.RECIPE_WRAPPER);
    }

    private <T> void addMachineRecipes(IModRegistry registry, IORecipeCategory<T> category, IRecipeWrapperGenerator<T> wrappergen) {
        registry.addRecipeCategories(new IRecipeCategory[]{category});
        registry.addRecipes((Collection)wrappergen.getRecipeList(category), category.getUid());
        registry.addRecipeCatalyst((Object)category.getBlockStack(), new String[]{category.getUid()});
    }

    public static class CustomHeightDynamicCategory<T>
    extends DynamicCategory<T> {
        protected final int height;

        public CustomHeightDynamicCategory(ITeBlock block, T recipeManager, IGuiHelper guiHelper, int height) {
            super(block, recipeManager, guiHelper);
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }
    }

    protected static final class BreederReactorCategory
    extends CustomHeightDynamicCategory<Object> {
        BreederReactorCategory(IGuiHelper guiHelper) {
            super(TesRegistry.breeding_reactor, new Object(), guiHelper, 63);
        }

        protected int getProcessSpeed(String name) {
            if ("progress".equals(name)) {
                return 50;
            }
            return super.getProcessSpeed(name);
        }
    }

    protected static final class BreederReactorRecipeWrapper
    extends IORecipeWrapper {
        public static final IRecipeWrapperGenerator<Object> RECIPE_WRAPPER = new IRecipeWrapperGenerator<Object>(){

            public List<IRecipeWrapper> getRecipeList(IORecipeCategory<Object> category) {
                ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
                for (BreederReactorRecipesHandler.Recipe r : BreederReactorRecipesHandler.getAllRecipes()) {
                    recipes.add((IRecipeWrapper)new BreederReactorRecipeWrapper(r, category));
                }
                return recipes;
            }
        };
        private final String inputText;
        private final String outputText;
        private final String totalEuText;
        private final String timeText;

        BreederReactorRecipeWrapper(BreederReactorRecipesHandler.Recipe r, IORecipeCategory<?> category) {
            super(BreederReactorRecipeWrapper.wrap(r.input), Collections.singletonList(r.output), category);
            IRecipeInput wrapped = BreederReactorRecipeWrapper.wrap(r.input);
            String resolvedInput = !wrapped.getInputs().isEmpty() ? wrapped.getInputs().get(0).func_82833_r() : (wrapped instanceof RecipeInputOreDict ? ((RecipeInputOreDict)wrapped).input : "Empty " + wrapped.getClass().getSimpleName());
            int seconds = Math.max(0, r.totalTime / 20);
            String mmss = String.format("%d:%02d", seconds / 60, seconds % 60);
            this.inputText = Localization.translate((String)"gui.ic2additions.inputBR") + ' ' + resolvedInput;
            this.outputText = Localization.translate((String)"gui.ic2additions.outputItemBR") + ' ' + r.output.func_82833_r();
            this.totalEuText = String.format("%s %,d %s", Localization.translate((String)"gui.ic2additions.costBR"), r.totalEU, Localization.translate((String)"ic2.generic.text.EU"));
            this.timeText = Localization.translate((String)"gui.ic2additions.countdownBR") + ' ' + mmss;
        }

        private static IRecipeInput wrap(final ItemStack stack) {
            return new IRecipeInput(){

                @Override
                public boolean matches(ItemStack other) {
                    if (other == null) {
                        return false;
                    }
                    return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)other) && stack.func_77960_j() == other.func_77960_j();
                }

                @Override
                public int getAmount() {
                    return stack.func_190916_E();
                }

                @Override
                public List<ItemStack> getInputs() {
                    return Collections.singletonList(stack);
                }
            };
        }

        public void drawInfo(Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int x = 5;
            mc.field_71466_p.func_78279_b(this.inputText, 42, x, recipeWidth - 42, 0xFFFFFF);
            mc.field_71466_p.func_78279_b(this.outputText, 42, x += mc.field_71466_p.func_78267_b(this.inputText, recipeWidth - 42) + 5, recipeWidth - 42, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.totalEuText, 42, x += mc.field_71466_p.func_78267_b(this.outputText, recipeWidth - 42) + 5, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.timeText, 42, x += 10, 0xFFFFFF);
        }
    }
}

