/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items;

import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import com.ic2additions.interfaces.IHot;
import ic2.core.IC2Potion;
import ic2.core.item.ItemNuclearResource;
import ic2.core.item.armor.ItemArmorHazmat;
import ic2.core.item.reactor.ItemReactorUranium;
import ic2.core.item.type.IRadioactiveItemType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ItemRadioactiveHot
extends Item
implements IRadioactiveItemType,
IHot {
    private final int radiationDuration;
    private final int radiationAmplifier;

    public ItemRadioactiveHot(String name, int radiationDuration, int radiationAmplifier) {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        this.func_77625_d(64);
        this.radiationDuration = radiationDuration;
        this.radiationAmplifier = radiationAmplifier;
        ItemInit.ITEMS.add(this);
    }

    public int getRadiationDuration() {
        return this.radiationDuration;
    }

    public int getRadiationAmplifier() {
        return this.radiationAmplifier;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (world.field_72995_K || !(entity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)entity;
        if (!ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)living)) {
            IC2Potion.radiation.applyTo(living, this.radiationDuration * 20, this.radiationAmplifier);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        for (ItemStack s : player.field_71071_by.field_70462_a) {
            if (s.func_190926_b() || !(s.func_77973_b() instanceof IHot)) continue;
            player.func_70015_d(2);
            return;
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        String line;
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() instanceof IHot) {
            line = TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.ic2additions.hot", (Object[])new Object[0]);
            if (!event.getToolTip().contains(line)) {
                event.getToolTip().add(line);
            }
        }
        if (stack.func_77973_b() instanceof IRadioactiveItemType || stack.func_77973_b() instanceof ItemNuclearResource || stack.func_77973_b() instanceof ItemReactorUranium) {
            line = TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.ic2additions.radioactive", (Object[])new Object[0]);
            if (!event.getToolTip().contains(line)) {
                event.getToolTip().add(line);
            }
        }
    }
}

