/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.armor;

import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import com.ic2additions.util.IC2AdditionsKeys;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.armor.jetpack.IBoostingJetpack;
import ic2.core.util.StackUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAdvancedNanoArmour
extends ItemArmorElectric
implements IBoostingJetpack {
    public static final String TAG_FLY = "isFlyActive";
    public static final String TAG_HOVER = "hoverMode";
    public static final String TAG_TOGGLE_TIMER = "toggleTimer";

    public ItemAdvancedNanoArmour(String name, EntityEquipmentSlot slot) {
        super(null, "advanced_nano_suit", slot, 1.0E7, 4096.0, 4);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        this.func_77625_d(1);
        ItemInit.ITEMS.add((Item)this);
    }

    public static boolean isJetpackOn(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_FLY);
    }

    public static boolean isHovering(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_HOVER);
    }

    public static boolean switchJetpack(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean newMode = !nbt.func_74767_n(TAG_FLY);
        nbt.func_74757_a(TAG_FLY, newMode);
        return newMode;
    }

    public static boolean switchHover(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean newMode = !nbt.func_74767_n(TAG_HOVER);
        nbt.func_74757_a(TAG_HOVER, newMode);
        return newMode;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        String mode;
        if (this.field_77881_a != EntityEquipmentSlot.CHEST) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        byte toggleTimer = nbt.func_74771_c(TAG_TOGGLE_TIMER);
        if (IC2AdditionsKeys.isFlyKeyDown(player) && toggleTimer == 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
            if (!world.field_72995_K) {
                boolean on = ItemAdvancedNanoArmour.switchJetpack(stack);
                mode = on ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.off");
                ItemAdvancedNanoArmour.sendStatus(player, "ic2additions.message.jetpackSwitch", TextFormatting.YELLOW, mode);
            }
        }
        if (IC2AdditionsKeys.isHoverKeyDown(player) && toggleTimer == 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
            if (!world.field_72995_K) {
                boolean hover = ItemAdvancedNanoArmour.switchHover(stack);
                mode = hover ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.hover_on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.hover_off");
                ItemAdvancedNanoArmour.sendStatus(player, "ic2additions.message.hoverSwitch", TextFormatting.YELLOW, mode);
            }
        }
        if (toggleTimer > 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)(toggleTimer - 1));
        }
    }

    private static void sendStatus(EntityPlayer player, String key, TextFormatting color, Object ... args) {
        TextComponentTranslation msg = new TextComponentTranslation(key, args);
        msg.func_150255_a(new Style().func_150238_a(color));
        player.func_145747_a((ITextComponent)msg);
    }

    public boolean isJetpackActive(ItemStack stack) {
        return ItemAdvancedNanoArmour.isJetpackOn(stack);
    }

    public double getChargeLevel(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public float getPower(ItemStack stack) {
        return 1.0f;
    }

    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    public float getBaseThrust(ItemStack stack, boolean hover) {
        return hover ? 0.65f : 0.3f;
    }

    public float getBoostThrust(EntityPlayer player, ItemStack stack, boolean hover) {
        return IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.getCharge(stack) >= 60.0 ? (hover ? 0.07f : 0.09f) : 0.0f;
    }

    public boolean useBoostPower(ItemStack stack, float boostAmount) {
        return ElectricItem.manager.discharge(stack, 60.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public float getWorldHeightDivisor(ItemStack stack) {
        return 1.0f;
    }

    public float getHoverMultiplier(ItemStack stack, boolean upwards) {
        return 0.2f;
    }

    public float getHoverBoost(EntityPlayer player, ItemStack stack, boolean up) {
        if (IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.getCharge(stack) >= 60.0) {
            if (!player.field_70122_E) {
                ElectricItem.manager.discharge(stack, 60.0, Integer.MAX_VALUE, true, false, false);
            }
            return 2.0f;
        }
        return 1.0f;
    }

    public boolean drainEnergy(ItemStack pack, int amount) {
        return ElectricItem.manager.discharge(pack, (double)amount * 6.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "ic2additions:textures/armor/advanced_nano_" + (slot == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }

    public double getDamageAbsorptionRatio() {
        return 0.8;
    }

    public int getEnergyPerDamage() {
        return 50000;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public String func_77658_a() {
        return "item.ic2additions." + this.getRegistryName().func_110623_a();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77657_g(ItemStack stack) {
        return this.func_77658_a();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.nightvision", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.jetpack", (Object[])new Object[0]));
    }
}

