/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.armor;

import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import com.ic2additions.init.SoundInit;
import com.ic2additions.util.IC2AdditionsKeys;
import ic2.api.item.ElectricItem;
import ic2.api.item.HudMode;
import ic2.api.item.IHazmatLike;
import ic2.api.item.IItemHudProvider;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.armor.jetpack.IBoostingJetpack;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="ic2additions")
public class ItemArmorMolecular
extends ItemArmorElectric
implements IBoostingJetpack,
IItemHudProvider,
IHazmatLike {
    public static final String TAG_FLY = "isFlyActive";
    public static final String TAG_HOVER = "hoverMode";
    public static final String TAG_TOGGLE_TIMER = "toggleTimer";
    public static final String TAG_FIRE_MODE = "fireMode";
    public static final String TAG_HAND_FASTBREAK = "handFastbreak";
    public static final String TAG_PUNCH_MODE = "punchMode";
    private static final String NBT_HAND_MODE = "handMode";
    private static final String MODE_NONE = "NONE";
    private static final String MODE_SILK = "SILK";
    private static final String TAG_MODE_CURSOR = "modeCursor";
    private static final float IGNORE_BELOW = 20.0f;
    private static final float HAND_SPEED = 20000.0f;
    private static final double FASTBREAK_COST_PER_PIECE = 1000000.0;
    private static final double PUNCH_COST_TOTAL = 5000000.0;
    private static final float PUNCH_DAMAGE = 20.0f;
    private static final float PUNCH_KNOCKBACK = 6.0f;
    private float jumpCharge = 0.0f;

    public ItemArmorMolecular(String name, EntityEquipmentSlot slot) {
        super(null, "molecular", slot, 7.5E8, 131072.0, 7);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        this.func_77625_d(1);
        ItemInit.ITEMS.add((Item)this);
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public double getDamageAbsorptionRatio() {
        return 2.5;
    }

    public int getEnergyPerDamage() {
        return 50000;
    }

    private static boolean isChest(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemArmorMolecular && ((ItemArmorMolecular)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.CHEST;
    }

    public static boolean isJetpackOn(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_FLY);
    }

    public static boolean isHovering(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_HOVER);
    }

    public static boolean switchJetpack(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean on = !nbt.func_74767_n(TAG_FLY);
        nbt.func_74757_a(TAG_FLY, on);
        return on;
    }

    public static boolean switchHover(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean on = !nbt.func_74767_n(TAG_HOVER);
        nbt.func_74757_a(TAG_HOVER, on);
        return on;
    }

    private static String readHandMode(ItemStack stack) {
        String m = StackUtil.getOrCreateNbtData((ItemStack)stack).func_74779_i(NBT_HAND_MODE);
        return MODE_SILK.equals(m) ? MODE_SILK : MODE_NONE;
    }

    private static void writeHandMode(ItemStack stack, String mode) {
        StackUtil.getOrCreateNbtData((ItemStack)stack).func_74778_a(NBT_HAND_MODE, MODE_SILK.equals(mode) ? MODE_SILK : MODE_NONE);
    }

    private static boolean isHandSilk(ItemStack stack) {
        return MODE_SILK.equals(ItemArmorMolecular.readHandMode(stack));
    }

    private static boolean isHandFastbreak(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_HAND_FASTBREAK);
    }

    private static void setHandFastbreak(ItemStack stack, boolean on) {
        StackUtil.getOrCreateNbtData((ItemStack)stack).func_74757_a(TAG_HAND_FASTBREAK, on);
    }

    private static boolean isPunchMode(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_PUNCH_MODE);
    }

    private static void setPunchMode(ItemStack stack, boolean on) {
        StackUtil.getOrCreateNbtData((ItemStack)stack).func_74757_a(TAG_PUNCH_MODE, on);
    }

    private static int getModeCursor(ItemStack chest) {
        return StackUtil.getOrCreateNbtData((ItemStack)chest).func_74762_e(TAG_MODE_CURSOR);
    }

    private static void setModeCursor(ItemStack chest, int v) {
        StackUtil.getOrCreateNbtData((ItemStack)chest).func_74768_a(TAG_MODE_CURSOR, (v % 5 + 5) % 5);
    }

    private static int nextCursor(int v) {
        return (v + 1) % 5;
    }

    private static String loc(String key) {
        return Localization.translate((String)key);
    }

    private static boolean anyModeActive(ItemStack chest) {
        if (StackUtil.isEmpty((ItemStack)chest)) {
            return false;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)chest);
        return nbt.func_74767_n(TAG_FIRE_MODE) || nbt.func_74767_n(TAG_HAND_FASTBREAK) || MODE_SILK.equals(nbt.func_74779_i(NBT_HAND_MODE)) || nbt.func_74767_n(TAG_PUNCH_MODE);
    }

    private static String currentModeLabel(ItemStack chest) {
        boolean fire = StackUtil.getOrCreateNbtData((ItemStack)chest).func_74767_n(TAG_FIRE_MODE);
        boolean hand = ItemArmorMolecular.isHandFastbreak(chest);
        boolean silk = ItemArmorMolecular.isHandSilk(chest);
        boolean punch = ItemArmorMolecular.isPunchMode(chest);
        if (fire) {
            return ItemArmorMolecular.loc("ic2additions.mode.fire");
        }
        if (hand) {
            return silk ? ItemArmorMolecular.loc("ic2additions.mode.hand_silk") : ItemArmorMolecular.loc("ic2additions.mode.hand");
        }
        if (punch) {
            return ItemArmorMolecular.loc("ic2additions.mode.punch");
        }
        return ItemArmorMolecular.loc("ic2additions.mode.none");
    }

    private static void sendSuitModeMsg(EntityPlayer player, ItemStack chest) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        String label = ItemArmorMolecular.currentModeLabel(chest);
        TextComponentTranslation msg = new TextComponentTranslation("ic2additions.message.suit_mode", new Object[]{label});
        msg.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        player.func_145747_a((ITextComponent)msg);
    }

    private static void setSuitFireModeSilent(ItemStack chest, boolean on) {
        StackUtil.getOrCreateNbtData((ItemStack)chest).func_74757_a(TAG_FIRE_MODE, on);
    }

    private static void setNoneAndAnnounce(EntityPlayer player, ItemStack chest) {
        ItemArmorMolecular.setSuitFireModeSilent(chest, false);
        ItemArmorMolecular.setHandFastbreak(chest, false);
        ItemArmorMolecular.setPunchMode(chest, false);
        ItemArmorMolecular.writeHandMode(chest, MODE_NONE);
        ItemArmorMolecular.setModeCursor(chest, 4);
        ItemArmorMolecular.sendSuitModeMsg(player, chest);
    }

    private static void applyModeByCursor(EntityPlayer player, ItemStack chest, int cursor) {
        ItemArmorMolecular.setSuitFireModeSilent(chest, false);
        ItemArmorMolecular.setHandFastbreak(chest, false);
        ItemArmorMolecular.setPunchMode(chest, false);
        ItemArmorMolecular.writeHandMode(chest, MODE_NONE);
        switch (cursor) {
            case 0: {
                ItemArmorMolecular.setSuitFireModeSilent(chest, true);
                break;
            }
            case 1: {
                ItemArmorMolecular.setHandFastbreak(chest, true);
                break;
            }
            case 2: {
                ItemArmorMolecular.setHandFastbreak(chest, true);
                ItemArmorMolecular.writeHandMode(chest, MODE_SILK);
                break;
            }
            case 3: {
                ItemArmorMolecular.setPunchMode(chest, true);
                break;
            }
        }
        ItemArmorMolecular.sendSuitModeMsg(player, chest);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            byte cur;
            byte timer = nbt.func_74771_c(TAG_TOGGLE_TIMER);
            boolean nightvision = nbt.func_74767_n("Nightvision");
            short hudMode = nbt.func_74765_d("HudMode");
            if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && timer == 0) {
                nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
                nightvision = !nightvision;
                nbt.func_74757_a("Nightvision", nightvision);
                if (IC2.platform.isSimulating()) {
                    IC2.platform.messagePlayer(player, nightvision ? "Nightvision enabled." : "Nightvision disabled.", new Object[0]);
                }
            }
            if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isHudModeKeyDown(player) && timer == 0) {
                nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
                hudMode = hudMode == HudMode.getMaxMode() ? (short)0 : (short)(hudMode + 1);
                nbt.func_74777_a("HudMode", hudMode);
                if (IC2.platform.isSimulating()) {
                    IC2.platform.messagePlayer(player, Localization.translate((String)HudMode.getFromID(hudMode).getTranslationKey()), new Object[0]);
                }
            }
            if (nightvision && IC2.platform.isSimulating() && ElectricItem.manager.use(stack, 1.0, (EntityLivingBase)player)) {
                BlockPos pos = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                int skylight = player.field_70170_p.func_175671_l(pos);
                if (skylight > 8) {
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76439_r);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0, true, true));
                } else {
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0, true, true));
                }
            }
            if ((cur = nbt.func_74771_c(TAG_TOGGLE_TIMER)) > 0) {
                nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)(cur - 1));
            }
            return;
        }
        if (ItemArmorMolecular.isChest(stack)) {
            byte cur;
            TextComponentTranslation msg;
            byte timer = nbt.func_74771_c(TAG_TOGGLE_TIMER);
            if (!ItemArmorMolecular.hasFullSet((EntityLivingBase)player) && ItemArmorMolecular.anyModeActive(stack)) {
                ItemArmorMolecular.setNoneAndAnnounce(player, stack);
            }
            if (IC2AdditionsKeys.isModeKeyDown(player) && timer == 0) {
                nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
                ItemStack chest = stack;
                int cursor = ItemArmorMolecular.getModeCursor(chest);
                ItemArmorMolecular.applyModeByCursor(player, chest, cursor);
                ItemArmorMolecular.setModeCursor(chest, ItemArmorMolecular.nextCursor(cursor));
            }
            if (IC2AdditionsKeys.isFlyKeyDown(player) && timer == 0) {
                nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
                if (!world.field_72995_K) {
                    boolean on = ItemArmorMolecular.switchJetpack(stack);
                    String mode = on ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.off");
                    msg = new TextComponentTranslation("ic2additions.message.jetpackSwitch", new Object[]{mode});
                    msg.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
                    player.func_145747_a((ITextComponent)msg);
                }
            }
            if (IC2AdditionsKeys.isHoverKeyDown(player) && timer == 0) {
                nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
                if (!world.field_72995_K) {
                    boolean hover = ItemArmorMolecular.switchHover(stack);
                    String mode = hover ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.hover_on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.hover_off");
                    msg = new TextComponentTranslation("ic2additions.message.hoverSwitch", new Object[]{mode});
                    msg.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
                    player.func_145747_a((ITextComponent)msg);
                }
            }
            if (!world.field_72995_K && ItemArmorMolecular.hasFullSet((EntityLivingBase)player) && nbt.func_74767_n(TAG_FIRE_MODE) && !ItemArmorMolecular.drainFromSet(player, 50000.0)) {
                ItemArmorMolecular.setSuitFireModeSilent(stack, false);
                TextComponentTranslation msg2 = new TextComponentTranslation("ic2additions.message.suit_fire_mode_auto_off", new Object[0]);
                msg2.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED));
                player.func_145747_a((ITextComponent)msg2);
            }
            if ((cur = nbt.func_74771_c(TAG_TOGGLE_TIMER)) > 0) {
                nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)(cur - 1));
            }
            return;
        }
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            boolean forward = IC2.keyboard.isForwardKeyDown(player);
            boolean sprintOrBoost = player.func_70051_ag() || IC2.keyboard.isBoostKeyDown(player);
            boolean canUse = ElectricItem.manager.canUse(stack, 1000.0);
            if (canUse && forward && (player.field_70122_E || player.func_70090_H()) && sprintOrBoost) {
                byte speedTicker = nbt.func_74771_c("speedTicker");
                if ((speedTicker = (byte)(speedTicker + 1)) >= 10) {
                    speedTicker = 0;
                    ElectricItem.manager.use(stack, 1000.0, null);
                }
                nbt.func_74774_a("speedTicker", speedTicker);
                float speed = 0.22f;
                if (player.func_70090_H()) {
                    speed = 0.1f;
                    if (IC2.keyboard.isJumpKeyDown(player)) {
                        player.field_70181_x += 0.1;
                    }
                }
                if (speed > 0.0f) {
                    player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                }
            }
            return;
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            if (IC2.platform.isSimulating()) {
                boolean wasOnGround;
                boolean bl = wasOnGround = nbt.func_74764_b("wasOnGround") ? nbt.func_74767_n("wasOnGround") : true;
                if (wasOnGround && !player.field_70122_E && IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.canUse(stack, 4000.0)) {
                    ElectricItem.manager.use(stack, 4000.0, null);
                }
                if (player.field_70122_E != wasOnGround) {
                    nbt.func_74757_a("wasOnGround", player.field_70122_E);
                }
            } else {
                if (ElectricItem.manager.canUse(stack, 4000.0) && player.field_70122_E) {
                    this.jumpCharge = 1.0f;
                }
                if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                    if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        if (this.jumpCharge == 1.0f) {
                            player.field_70159_w *= 3.5;
                            player.field_70179_y *= 3.5;
                        }
                        player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                        this.jumpCharge *= 0.75f;
                    } else if (this.jumpCharge < 1.0f) {
                        this.jumpCharge = 0.0f;
                    }
                }
            }
        }
    }

    public boolean isJetpackActive(ItemStack stack) {
        return ItemArmorMolecular.isChest(stack) && ItemArmorMolecular.isJetpackOn(stack);
    }

    public double getChargeLevel(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public float getPower(ItemStack stack) {
        return 1.0f;
    }

    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    public float getWorldHeightDivisor(ItemStack stack) {
        return 1.0f;
    }

    public float getHoverMultiplier(ItemStack stack, boolean upwards) {
        return 0.3f;
    }

    public float getBaseThrust(ItemStack stack, boolean hover) {
        return hover ? 0.65f : 0.3f;
    }

    public float getBoostThrust(EntityPlayer p, ItemStack s, boolean hover) {
        return IC2.keyboard.isBoostKeyDown(p) && ElectricItem.manager.getCharge(s) >= 60.0 ? (hover ? 0.07f : 0.09f) : 0.0f;
    }

    public boolean useBoostPower(ItemStack s, float amt) {
        return ElectricItem.manager.discharge(s, 60.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public float getHoverBoost(EntityPlayer p, ItemStack s, boolean up) {
        if (IC2.keyboard.isBoostKeyDown(p) && ElectricItem.manager.getCharge(s) >= 60.0) {
            if (!p.field_70122_E) {
                ElectricItem.manager.discharge(s, 60.0, Integer.MAX_VALUE, true, false, false);
            }
            return 2.0f;
        }
        return 1.0f;
    }

    public boolean drainEnergy(ItemStack s, int amt) {
        return ElectricItem.manager.discharge(s, (double)amt * 6.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    @Override
    public boolean doesProvideHUD(ItemStack stack) {
        return this.field_77881_a == EntityEquipmentSlot.HEAD && ElectricItem.manager.getCharge(stack) > 0.0;
    }

    @Override
    public HudMode getHudMode(ItemStack stack) {
        return HudMode.getFromID(StackUtil.getOrCreateNbtData((ItemStack)stack).func_74765_d("HudMode"));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.getEntity() instanceof EntityLivingBase && !StackUtil.isEmpty((ItemStack)(armor = (entity = (EntityLivingBase)event.getEntity()).func_184582_a(EntityEquipmentSlot.FEET))) && armor.func_77973_b() == this) {
            int fallDamage = Math.max((int)event.getDistance() - 10, 0);
            double energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCommand(CommandEvent event) {
        boolean selfKill;
        if (event.getCommand() == null) {
            return;
        }
        if (!"kill".equalsIgnoreCase(event.getCommand().func_71517_b())) {
            return;
        }
        if (!(event.getSender() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSender();
        if (!ItemArmorMolecular.hasFullSet((EntityLivingBase)player)) {
            return;
        }
        String[] args = event.getParameters();
        boolean bl = selfKill = args.length == 0 || player.func_70005_c_().equalsIgnoreCase(args[0]);
        if (!selfKill) {
            return;
        }
        event.setCanceled(true);
        if (!player.field_70170_p.field_72995_K) {
            TextComponentTranslation msg = new TextComponentTranslation("ic2additions.message.kill_protection", new Object[0]);
            msg.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED));
            player.func_145747_a((ITextComponent)msg);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        DamageSource src;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)event.getEntityLiving();
        if (!ItemArmorMolecular.hasFullSet((EntityLivingBase)p)) {
            return;
        }
        ItemStack chest = p.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!StackUtil.isEmpty((ItemStack)chest) && chest.func_77973_b() instanceof ItemArmorMolecular && StackUtil.getOrCreateNbtData((ItemStack)chest).func_74767_n(TAG_FIRE_MODE)) {
            EntityLivingBase entityLivingBase = src = event.getSource().func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)event.getSource().func_76346_g() : null;
            if (src != null) {
                src.func_70015_d(5);
            }
        }
        if (!ItemArmorMolecular.hasFullSet(event.getEntityLiving())) {
            return;
        }
        src = event.getSource();
        if (src.func_76347_k() || src == DamageSource.field_190095_e || src == DamageSource.field_76371_c) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (StackUtil.isEmpty((ItemStack)chest) || !(chest.func_77973_b() instanceof ItemArmorMolecular)) {
            return;
        }
        if (StackUtil.getOrCreateNbtData((ItemStack)chest).func_74767_n(TAG_PUNCH_MODE) && event.getTarget() instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)event.getTarget();
            if (ElectricItem.manager.canUse(chest, 1000000.0)) {
                ElectricItem.manager.use(chest, 1000000.0, null);
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 20.0f);
                target.func_70653_a((Entity)player, 6.0f, Math.sin(Math.toRadians(player.field_70177_z)), -Math.cos(Math.toRadians(player.field_70177_z)));
                if (player.field_70170_p.field_72995_K) {
                    player.func_184185_a(SoundInit.MOLECULAR_PUNCH, 1.0f, 1.0f);
                } else {
                    player.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundInit.MOLECULAR_PUNCH, target.func_184176_by(), 1.0f, 1.0f);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)event.getEntityLiving();
        if (!ItemArmorMolecular.hasFullSet((EntityLivingBase)p)) {
            return;
        }
        if (event.getAmount() < 20.0f) {
            event.setCanceled(true);
            event.setAmount(0.0f);
            p.field_70737_aN = 0;
            p.field_70738_aO = 0;
            p.field_70739_aP = 0.0f;
            p.field_70172_ad = 0;
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (ItemArmorMolecular.hasFullSet(event.getEntityLiving()) && event.getEntityLiving().func_70027_ad()) {
            event.getEntityLiving().func_70066_B();
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        ItemStack chest;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!ItemArmorMolecular.hasFullSet((EntityLivingBase)player) && !StackUtil.isEmpty((ItemStack)(chest = player.func_184582_a(EntityEquipmentSlot.CHEST))) && chest.func_77973_b() instanceof ItemArmorMolecular && ItemArmorMolecular.anyModeActive(chest)) {
            ItemArmorMolecular.setNoneAndAnnounce(player, chest);
        }
    }

    public static boolean hasFullSet(EntityLivingBase e) {
        if (e == null) {
            return false;
        }
        int count = 0;
        for (ItemStack s : e.func_184193_aE()) {
            if (StackUtil.isEmpty((ItemStack)s) || !(s.func_77973_b() instanceof ItemArmorMolecular)) continue;
            ++count;
        }
        return count == 4;
    }

    private static boolean isMolecularPiece(ItemStack s, EntityEquipmentSlot slot) {
        return !StackUtil.isEmpty((ItemStack)s) && s.func_77973_b() instanceof ItemArmorMolecular && ((ItemArmorMolecular)s.func_77973_b()).field_77881_a == slot;
    }

    private static double charge(ItemStack s) {
        return StackUtil.isEmpty((ItemStack)s) ? 0.0 : ElectricItem.manager.getCharge(s);
    }

    public static boolean drainFromSet(EntityPlayer p, double amountPerTick) {
        ItemStack head = p.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = p.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = p.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = p.func_184582_a(EntityEquipmentSlot.FEET);
        ArrayList<ItemStack> pieces = new ArrayList<ItemStack>(4);
        if (ItemArmorMolecular.isMolecularPiece(head, EntityEquipmentSlot.HEAD) && ItemArmorMolecular.charge(head) > 0.0) {
            pieces.add(head);
        }
        if (ItemArmorMolecular.isMolecularPiece(chest, EntityEquipmentSlot.CHEST) && ItemArmorMolecular.charge(chest) > 0.0) {
            pieces.add(chest);
        }
        if (ItemArmorMolecular.isMolecularPiece(legs, EntityEquipmentSlot.LEGS) && ItemArmorMolecular.charge(legs) > 0.0) {
            pieces.add(legs);
        }
        if (ItemArmorMolecular.isMolecularPiece(feet, EntityEquipmentSlot.FEET) && ItemArmorMolecular.charge(feet) > 0.0) {
            pieces.add(feet);
        }
        if (pieces.isEmpty()) {
            return false;
        }
        double total = 0.0;
        for (ItemStack s : pieces) {
            total += ItemArmorMolecular.charge(s);
        }
        if (total + 1.0E-6 < amountPerTick) {
            return false;
        }
        double remaining = amountPerTick;
        for (int pass = 0; pass < 4 && remaining > 1.0E-6 && !pieces.isEmpty(); ++pass) {
            int n = pieces.size();
            double perShare = remaining / (double)n;
            Iterator it = pieces.iterator();
            while (it.hasNext()) {
                ItemStack s = (ItemStack)it.next();
                double avail = ItemArmorMolecular.charge(s);
                double want = Math.min(perShare, avail);
                if (want <= 0.0) {
                    it.remove();
                    continue;
                }
                double pulled = ElectricItem.manager.discharge(s, want, Integer.MAX_VALUE, true, false, false);
                remaining -= pulled;
            }
            pieces.removeIf(ps -> ItemArmorMolecular.charge(ps) <= 1.0E-6);
        }
        return remaining <= 1.0E-6;
    }

    private static boolean drainEachPiece(EntityPlayer p, double amountPerPiece) {
        ItemStack head = p.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = p.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = p.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = p.func_184582_a(EntityEquipmentSlot.FEET);
        ArrayList<ItemStack> pieces = new ArrayList<ItemStack>(4);
        if (ItemArmorMolecular.isMolecularPiece(head, EntityEquipmentSlot.HEAD)) {
            pieces.add(head);
        }
        if (ItemArmorMolecular.isMolecularPiece(chest, EntityEquipmentSlot.CHEST)) {
            pieces.add(chest);
        }
        if (ItemArmorMolecular.isMolecularPiece(legs, EntityEquipmentSlot.LEGS)) {
            pieces.add(legs);
        }
        if (ItemArmorMolecular.isMolecularPiece(feet, EntityEquipmentSlot.FEET)) {
            pieces.add(feet);
        }
        if (pieces.size() != 4) {
            return false;
        }
        for (ItemStack s : pieces) {
            if (!(ElectricItem.manager.getCharge(s) + 1.0E-6 < amountPerPiece)) continue;
            return false;
        }
        for (ItemStack s : pieces) {
            double drained = ElectricItem.manager.discharge(s, amountPerPiece, Integer.MAX_VALUE, true, false, false);
            if (!(drained + 1.0E-6 < amountPerPiece)) continue;
            return false;
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.nightvision", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.jetpack", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.highjump", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.fastwalk", (Object[])new Object[0]));
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.ic2additions.thermohazmat_set", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.BOLD + I18n.func_135052_a((String)"tooltip.ic2additions.armor_firemode", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.BOLD + I18n.func_135052_a((String)"tooltip.ic2additions.armor_fastbreak", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.BOLD + I18n.func_135052_a((String)"tooltip.ic2additions.armor_fastbreaksilk", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.BOLD + I18n.func_135052_a((String)"tooltip.ic2additions.armor_hardpunch", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.ic2additions.radiation_protection", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.ic2additions.fire_prox.protects_fire", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.ic2additions.fall_damage_neutralization", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.ic2additions.armor_cannotbekilled", (Object[])new Object[0]));
    }

    private static boolean fullSetAndFastbreakOn(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (!ItemArmorMolecular.hasFullSet((EntityLivingBase)player)) {
            return false;
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return !StackUtil.isEmpty((ItemStack)chest) && chest.func_77973_b() instanceof ItemArmorMolecular && ItemArmorMolecular.isHandFastbreak(chest);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer p = event.getEntityPlayer();
        if (p == null || p.field_71075_bZ.field_75098_d) {
            return;
        }
        if (!ItemArmorMolecular.fullSetAndFastbreakOn(p)) {
            return;
        }
        IBlockState state = event.getState();
        if (state == null) {
            return;
        }
        Block block = state.func_177230_c();
        if (block == Blocks.field_150357_h) {
            return;
        }
        if (!p.func_184614_ca().func_190926_b()) {
            return;
        }
        event.setNewSpeed(20000.0f);
    }

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        EntityPlayer p = event.getEntityPlayer();
        if (p == null) {
            return;
        }
        if (!ItemArmorMolecular.fullSetAndFastbreakOn(p)) {
            return;
        }
        IBlockState state = event.getTargetBlock();
        if (state == null) {
            return;
        }
        if (state.func_177230_c() == Blocks.field_150357_h) {
            return;
        }
        event.setCanHarvest(true);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer p = event.getPlayer();
        if (p == null || p.field_71075_bZ.field_75098_d) {
            return;
        }
        if (!ItemArmorMolecular.fullSetAndFastbreakOn(p)) {
            return;
        }
        IBlockState state = event.getState();
        if (state == null) {
            return;
        }
        if (state.func_177230_c() == Blocks.field_150357_h) {
            return;
        }
        if (!p.func_184614_ca().func_190926_b()) {
            return;
        }
        if (!ItemArmorMolecular.drainEachPiece(p, 1000000.0)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer ep = event.getEntityPlayer();
        if (!(ep instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)ep;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (!ItemArmorMolecular.fullSetAndFastbreakOn((EntityPlayer)player)) {
            return;
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!ItemArmorMolecular.isHandSilk(chest)) {
            return;
        }
        if (!player.func_184614_ca().func_190926_b()) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        if (state == null || state.func_177230_c() == Blocks.field_150357_h) {
            return;
        }
        GameType gt = player.field_71134_c.func_73081_b();
        int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gt, (EntityPlayerMP)player, (BlockPos)pos);
        if (xp < 0) {
            return;
        }
        if (!ItemArmorMolecular.drainFromSet((EntityPlayer)player, 4000000.0)) {
            return;
        }
        ItemStack fake = new ItemStack(Blocks.field_150348_b);
        HashMap<Enchantment, Integer> ench = new HashMap<Enchantment, Integer>();
        ench.put(Enchantments.field_185306_r, 1);
        EnchantmentHelper.func_82782_a(ench, (ItemStack)fake);
        state.func_177230_c().func_176208_a(world, pos, state, (EntityPlayer)player);
        if (state.func_177230_c().removedByPlayer(state, world, pos, (EntityPlayer)player, true)) {
            state.func_177230_c().func_176206_d(world, pos, state);
            state.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, state, world.func_175625_s(pos), fake);
            if (xp > 0) {
                state.func_177230_c().func_180637_b(world, pos, xp);
            }
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackEntity(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (!ItemArmorMolecular.hasFullSet((EntityLivingBase)player)) {
            return;
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (StackUtil.isEmpty((ItemStack)chest) || !(chest.func_77973_b() instanceof ItemArmorMolecular)) {
            return;
        }
        if (!ItemArmorMolecular.isPunchMode(chest)) {
            return;
        }
        if (!player.func_184614_ca().func_190926_b()) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)target;
        if (!ItemArmorMolecular.drainFromSet(player, 5000000.0)) {
            return;
        }
        event.setCanceled(true);
        victim.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 20.0f);
        double dx = player.field_70165_t - victim.field_70165_t;
        double dz = player.field_70161_v - victim.field_70161_v;
        victim.func_70653_a((Entity)player, 6.0f, dx, dz);
        player.func_184609_a(player.func_184600_cs());
    }

    @Override
    public boolean addsProtection(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) > 0.0;
    }

    @Override
    public boolean fullyProtects(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return false;
    }

    public String func_77658_a() {
        return "item.ic2additions." + this.getRegistryName().func_110623_a();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77657_g(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "ic2additions:textures/armor/molecular_" + (slot == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }
}

