/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.armor;

import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import com.ic2additions.util.IC2AdditionsKeys;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.armor.jetpack.IBoostingJetpack;
import ic2.core.util.StackUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemArmorSeraphimMK2
extends ItemArmorElectric
implements IBoostingJetpack {
    public static final String TAG_FLY = "isFlyActive";
    public static final String TAG_HOVER = "hoverMode";
    public static final String TAG_TOGGLE_TIMER = "toggleTimer";

    public ItemArmorSeraphimMK2(String name, EntityEquipmentSlot slot) {
        super(null, "seraphim_mk2", slot, 5.0E7, 8192.0, 5);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        this.func_77625_d(1);
        ItemInit.ITEMS.add((Item)this);
    }

    public static boolean isJetpackOn(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_FLY);
    }

    public static boolean isHovering(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_HOVER);
    }

    public static boolean switchJetpack(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean newMode = !nbt.func_74767_n(TAG_FLY);
        nbt.func_74757_a(TAG_FLY, newMode);
        return newMode;
    }

    public static boolean switchHover(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean newMode = !nbt.func_74767_n(TAG_HOVER);
        nbt.func_74757_a(TAG_HOVER, newMode);
        return newMode;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        String mode;
        if (this.field_77881_a != EntityEquipmentSlot.CHEST) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        byte toggleTimer = nbt.func_74771_c(TAG_TOGGLE_TIMER);
        if (IC2AdditionsKeys.isFlyKeyDown(player) && toggleTimer == 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
            if (!world.field_72995_K) {
                boolean on = ItemArmorSeraphimMK2.switchJetpack(stack);
                mode = on ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.off");
                ItemArmorSeraphimMK2.sendStatus(player, "ic2additions.message.jetpackSwitch", TextFormatting.YELLOW, mode);
            }
        }
        if (IC2AdditionsKeys.isHoverKeyDown(player) && toggleTimer == 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
            if (!world.field_72995_K) {
                boolean hover = ItemArmorSeraphimMK2.switchHover(stack);
                mode = hover ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.hover_on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.hover_off");
                ItemArmorSeraphimMK2.sendStatus(player, "ic2additions.message.hoverSwitch", TextFormatting.YELLOW, mode);
            }
        }
        if (toggleTimer > 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)(toggleTimer - 1));
        }
    }

    private static void sendStatus(EntityPlayer player, String key, TextFormatting color, Object ... args) {
        TextComponentTranslation msg = new TextComponentTranslation(key, args);
        msg.func_150255_a(new Style().func_150238_a(color));
        player.func_145747_a((ITextComponent)msg);
    }

    public boolean isJetpackActive(ItemStack stack) {
        return ItemArmorSeraphimMK2.isJetpackOn(stack);
    }

    public double getChargeLevel(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public float getPower(ItemStack stack) {
        return 1.0f;
    }

    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    public float getBaseThrust(ItemStack stack, boolean hover) {
        return hover ? 0.65f : 0.3f;
    }

    public float getBoostThrust(EntityPlayer player, ItemStack stack, boolean hover) {
        return IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.getCharge(stack) >= 60.0 ? (hover ? 0.07f : 0.09f) : 0.0f;
    }

    public boolean useBoostPower(ItemStack stack, float boostAmount) {
        return ElectricItem.manager.discharge(stack, 60.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public float getWorldHeightDivisor(ItemStack stack) {
        return 1.0f;
    }

    public float getHoverMultiplier(ItemStack stack, boolean upwards) {
        return 0.2f;
    }

    public float getHoverBoost(EntityPlayer player, ItemStack stack, boolean up) {
        if (IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.getCharge(stack) >= 60.0) {
            if (!player.field_70122_E) {
                ElectricItem.manager.discharge(stack, 60.0, Integer.MAX_VALUE, true, false, false);
            }
            return 2.0f;
        }
        return 1.0f;
    }

    public boolean drainEnergy(ItemStack pack, int amount) {
        return ElectricItem.manager.discharge(pack, (double)amount * 6.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public static boolean hasFullSet(EntityLivingBase e) {
        if (e == null) {
            return false;
        }
        int count = 0;
        for (ItemStack s : e.func_184193_aE()) {
            if (s.func_190926_b() || !(s.func_77973_b() instanceof ItemArmorSeraphimMK2)) continue;
            ++count;
        }
        return count == 4;
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!ItemArmorSeraphimMK2.hasFullSet(event.getEntityLiving())) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70027_ad()) {
            entity.func_70066_B();
        }
        entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 20, 0, true, false));
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (!ItemArmorSeraphimMK2.hasFullSet(event.getEntityLiving())) {
            return;
        }
        DamageSource src = event.getSource();
        if (src.func_76347_k() || src == DamageSource.field_190095_e || src == DamageSource.field_76371_c) {
            event.setCanceled(true);
            return;
        }
        if (src == DamageSource.field_76379_h) {
            event.setCanceled(true);
            return;
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.nightvision", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.jetpack", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.ic2additions.thermohazmat_set", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.ic2additions.fire_prox.protects_fire", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.ic2additions.strength_1", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.ic2additions.fall_damage_neutralization", (Object[])new Object[0]));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "ic2additions:textures/armor/seraphim_mk2_" + (slot == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }

    public double getDamageAbsorptionRatio() {
        return 0.95;
    }

    public int getEnergyPerDamage() {
        return 100000;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public String func_77658_a() {
        return "item.ic2additions." + this.getRegistryName().func_110623_a();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77657_g(ItemStack stack) {
        return this.func_77658_a();
    }
}

