/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.armor;

import com.ic2additions.init.ItemInit;
import ic2.api.item.ElectricItem;
import ic2.api.item.HudMode;
import ic2.api.item.IHazmatLike;
import ic2.api.item.IItemHudProvider;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.init.Localization;
import ic2.core.init.MainConfig;
import ic2.core.item.ItemTinCan;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.armor.jetpack.IJetpack;
import ic2.core.ref.ItemName;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.StackUtil;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemQuantumArmor
extends ItemArmorElectric
implements IJetpack,
IHazmatLike,
IItemHudProvider {
    private static final double MAX_CHARGE = 1.0E8;
    private static final double TRANSFER = 32767.0;
    private static final int TIER = 6;
    protected static final Map<Potion, Integer> potionRemovalCost = new IdentityHashMap<Potion, Integer>();
    private float jumpCharge;

    public ItemQuantumArmor(String name, EntityEquipmentSlot armorType) {
        super(null, "quantum_suit", armorType, 1.0E8, 32767.0, 6);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a((CreativeTabs)IC2.tabIC2);
        this.func_77625_d(1);
        ItemInit.ITEMS.add((Item)this);
        if (armorType == EntityEquipmentSlot.FEET) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        potionRemovalCost.put(MobEffects.field_76436_u, 10000);
        potionRemovalCost.put((Potion)IC2Potion.radiation, 10000);
        potionRemovalCost.put(MobEffects.field_82731_v, 25000);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "ic2additions:textures/armor/quantum_" + (slot == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }

    @Override
    public boolean addsProtection(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) > 0.0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        if (source == DamageSource.field_76379_h) {
            if (this.field_77881_a == EntityEquipmentSlot.FEET) {
                return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
            }
            if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
                return new ISpecialArmor.ArmorProperties(9, 0.8, damageLimit);
            }
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        return new ISpecialArmor.ArmorProperties(8, absorptionRatio, damageLimit);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.getEntity() instanceof EntityLivingBase && !StackUtil.isEmpty((ItemStack)(armor = (entity = (EntityLivingBase)event.getEntity()).func_184582_a(EntityEquipmentSlot.FEET))) && armor.func_77973_b() == this) {
            int fallDamage = Math.max((int)event.getDistance() - 10, 0);
            double energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                event.setCanceled(true);
            }
        }
    }

    public double getDamageAbsorptionRatio() {
        return this.field_77881_a == EntityEquipmentSlot.CHEST ? 1.2 : 1.0;
    }

    public int getEnergyPerDamage() {
        return 50000;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        switch (this.field_77881_a) {
            case HEAD: {
                IC2.platform.profilerStartSection("QuantumHelmet");
                int air = player.func_70086_ai();
                if (ElectricItem.manager.canUse(stack, 1000.0) && air < 100) {
                    player.func_70050_g(air + 200);
                    ElectricItem.manager.use(stack, 1000.0, null);
                    ret = true;
                } else if (air <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if (ElectricItem.manager.canUse(stack, 1000.0) && player.func_71024_bL().func_75121_c()) {
                    int slot = -1;
                    for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                        ItemStack playerStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                        if (StackUtil.isEmpty((ItemStack)playerStack) || playerStack.func_77973_b() != ItemName.filled_tin_can.getInstance()) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemStack playerStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
                        ItemTinCan can = (ItemTinCan)playerStack.func_77973_b();
                        ActionResult result = can.onEaten(player, playerStack);
                        if (StackUtil.isEmpty((ItemStack)(playerStack = (ItemStack)result.func_188398_b()))) {
                            player.field_71071_by.field_70462_a.set(slot, (Object)StackUtil.emptyStack);
                        }
                        if (result.func_188397_a() == EnumActionResult.SUCCESS) {
                            ElectricItem.manager.use(stack, 1000.0, null);
                        }
                        ret = true;
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                    Potion potion = effect.func_188419_a();
                    Integer cost = potionRemovalCost.get(potion);
                    if (cost == null || !ElectricItem.manager.canUse(stack, (cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
                    ElectricItem.manager.use(stack, cost.intValue(), null);
                    IC2.platform.removePotion((EntityLivingBase)player, potion);
                }
                boolean Nightvision = nbtData.func_74767_n("Nightvision");
                short hubmode = nbtData.func_74765_d("HudMode");
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = Nightvision = !Nightvision;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("Nightvision", Nightvision);
                        IC2.platform.messagePlayer(player, Nightvision ? "Nightvision enabled." : "Nightvision disabled.", new Object[0]);
                    }
                }
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isHudModeKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    hubmode = hubmode == HudMode.getMaxMode() ? (short)0 : (short)(hubmode + 1);
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74777_a("HudMode", hubmode);
                        IC2.platform.messagePlayer(player, Localization.translate((String)HudMode.getFromID(hubmode).getTranslationKey()), new Object[0]);
                    }
                }
                if (IC2.platform.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (Nightvision && IC2.platform.isSimulating() && ElectricItem.manager.use(stack, 1.0, (EntityLivingBase)player)) {
                    BlockPos pos = new BlockPos((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
                    int skylight = player.func_130014_f_().func_175671_l(pos);
                    if (skylight > 8) {
                        IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76439_r);
                        player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0, true, true));
                    } else {
                        IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0, true, true));
                    }
                    ret = true;
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case CHEST: {
                IC2.platform.profilerStartSection("QuantumBodyarmor");
                player.func_70066_B();
                IC2.platform.profilerEndSection();
                break;
            }
            case LEGS: {
                boolean enableQuantumSpeedOnSprint;
                IC2.platform.profilerStartSection("QuantumLeggings");
                boolean bl = enableQuantumSpeedOnSprint = IC2.platform.isRendering() ? ConfigUtil.getBool((Config)MainConfig.get(), (String)"misc/quantumSpeedOnSprint") : true;
                if (ElectricItem.manager.canUse(stack, 1000.0) && (player.field_70122_E || player.func_70090_H()) && IC2.keyboard.isForwardKeyDown(player) && (enableQuantumSpeedOnSprint && player.func_70051_ag() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player))) {
                    byte speedTicker = nbtData.func_74771_c("speedTicker");
                    if ((speedTicker = (byte)(speedTicker + 1)) >= 10) {
                        speedTicker = 0;
                        ElectricItem.manager.use(stack, 1000.0, null);
                        ret = true;
                    }
                    nbtData.func_74774_a("speedTicker", speedTicker);
                    float speed = 0.22f;
                    if (player.func_70090_H()) {
                        speed = 0.1f;
                        if (IC2.keyboard.isJumpKeyDown(player)) {
                            player.field_70181_x += 0.1;
                        }
                    }
                    if (speed > 0.0f) {
                        player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                    }
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case FEET: {
                IC2.platform.profilerStartSection("QuantumBoots");
                if (IC2.platform.isSimulating()) {
                    boolean wasOnGround;
                    boolean bl = wasOnGround = nbtData.func_74764_b("wasOnGround") ? nbtData.func_74767_n("wasOnGround") : true;
                    if (wasOnGround && !player.field_70122_E && IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        ElectricItem.manager.use(stack, 4000.0, null);
                        ret = true;
                    }
                    if (player.field_70122_E != wasOnGround) {
                        nbtData.func_74757_a("wasOnGround", player.field_70122_E);
                    }
                } else {
                    if (ElectricItem.manager.canUse(stack, 4000.0) && player.field_70122_E) {
                        this.jumpCharge = 1.0f;
                    }
                    if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                            if (this.jumpCharge == 1.0f) {
                                player.field_70159_w *= 3.5;
                                player.field_70179_y *= 3.5;
                            }
                            player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                            this.jumpCharge *= 0.75f;
                        } else if (this.jumpCharge < 1.0f) {
                            this.jumpCharge = 0.0f;
                        }
                    }
                }
                IC2.platform.profilerEndSection();
            }
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean drainEnergy(ItemStack pack, int amount) {
        return ElectricItem.manager.discharge(pack, (double)amount + 6.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public float getPower(ItemStack stack) {
        return 1.0f;
    }

    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    public double getChargeLevel(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean isJetpackActive(ItemStack stack) {
        return true;
    }

    public float getHoverMultiplier(ItemStack stack, boolean upwards) {
        return 0.1f;
    }

    public float getWorldHeightDivisor(ItemStack stack) {
        return 0.9f;
    }

    @Override
    public boolean doesProvideHUD(ItemStack stack) {
        return this.field_77881_a == EntityEquipmentSlot.HEAD && ElectricItem.manager.getCharge(stack) > 0.0;
    }

    @Override
    public HudMode getHudMode(ItemStack stack) {
        return HudMode.getFromID(StackUtil.getOrCreateNbtData((ItemStack)stack).func_74765_d("HudMode"));
    }

    public String func_77658_a() {
        return "item.ic2additions." + this.getRegistryName().func_110623_a();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77657_g(ItemStack stack) {
        return this.func_77658_a();
    }

    public static boolean hasFullSet(EntityLivingBase e) {
        if (e == null) {
            return false;
        }
        int count = 0;
        for (ItemStack s : e.func_184193_aE()) {
            if (s.func_190926_b() || !(s.func_77973_b() instanceof ItemQuantumArmor)) continue;
            ++count;
        }
        return count == 4;
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!ItemQuantumArmor.hasFullSet(event.getEntityLiving())) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70027_ad()) {
            entity.func_70066_B();
        }
        entity.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 20, 1, true, false));
        entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 20, 1, true, false));
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (!ItemQuantumArmor.hasFullSet(event.getEntityLiving())) {
            return;
        }
        DamageSource src = event.getSource();
        if (src.func_76347_k() || src == DamageSource.field_190095_e || src == DamageSource.field_76371_c) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean fullyProtects(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.nightvision", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.jetpack", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.highjump", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.ic2additions.fastwalk", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.ic2additions.thermohazmat_set", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.ic2additions.radiation_protection", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.ic2additions.fire_prox.protects_fire", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.ic2additions.fall_damage_neutralization", (Object[])new Object[0]));
    }
}

