/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.armor;

import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import com.ic2additions.objects.items.armor.ItemAdvancedQuantumArmor;
import ic2.api.item.IHazmatLike;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemThermohazmatArmor
extends ItemArmor
implements IHazmatLike {
    public static final ItemArmor.ArmorMaterial THERMO_HAZMAT = EnumHelper.addArmorMaterial((String)"THERMO_HAZMAT", (String)"ic2additions:thermo_hazmat", (int)5, (int[])new int[]{1, 2, 3, 1}, (int)12, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);

    public ItemThermohazmatArmor(String name, EntityEquipmentSlot slot) {
        super(THERMO_HAZMAT, 0, slot);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        ItemInit.ITEMS.add((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "ic2additions:textures/armor/thermo_hazmat_" + (slot == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }

    public String func_77658_a() {
        return "item.ic2additions." + this.getRegistryName().func_110623_a();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77657_g(ItemStack stack) {
        return this.func_77658_a();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.ic2additions.thermohazmat_set", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.ic2additions.radiation_protection", (Object[])new Object[0]));
        tooltip.add("  " + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.ic2additions.fire_prox.protects_fire", (Object[])new Object[0]));
    }

    public static boolean hasFullSet(EntityLivingBase e) {
        if (e == null) {
            return false;
        }
        int count = 0;
        for (ItemStack s : e.func_184193_aE()) {
            if (s.func_190926_b() || !(s.func_77973_b() instanceof ItemAdvancedQuantumArmor)) continue;
            ++count;
        }
        return count == 4;
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (ItemThermohazmatArmor.hasFullSet(event.getEntityLiving()) && event.getEntityLiving().func_70027_ad()) {
            event.getEntityLiving().func_70066_B();
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (!ItemThermohazmatArmor.hasFullSet(event.getEntityLiving())) {
            return;
        }
        DamageSource src = event.getSource();
        if (src.func_76347_k() || src == DamageSource.field_190095_e || src == DamageSource.field_76371_c) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean addsProtection(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean fullyProtects(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return false;
    }
}

