/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.armor;

import com.ic2additions.objects.items.armor.ItemBaseEnergyPack;
import com.ic2additions.util.IC2AdditionsKeys;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.item.armor.jetpack.IBoostingJetpack;
import ic2.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemUnrealEnergyPack
extends ItemBaseEnergyPack
implements IBoostingJetpack {
    public static final String TAG_FLY = "isFlyActive";
    public static final String TAG_HOVER = "hoverMode";
    public static final String TAG_TOGGLE_TIMER = "toggleTimer";

    public ItemUnrealEnergyPack() {
        super("unreal_pack", 3.5E8, 200000.0, 5);
    }

    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public static boolean isJetpackOn(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_FLY);
    }

    public static boolean isHovering(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n(TAG_HOVER);
    }

    public static boolean switchJetpack(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean newMode = !nbt.func_74767_n(TAG_FLY);
        nbt.func_74757_a(TAG_FLY, newMode);
        return newMode;
    }

    public static boolean switchHover(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean newMode = !nbt.func_74767_n(TAG_HOVER);
        nbt.func_74757_a(TAG_HOVER, newMode);
        return newMode;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        String mode;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        byte toggleTimer = nbt.func_74771_c(TAG_TOGGLE_TIMER);
        if (IC2AdditionsKeys.isFlyKeyDown(player) && toggleTimer == 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
            if (!world.field_72995_K) {
                boolean on = ItemUnrealEnergyPack.switchJetpack(stack);
                mode = on ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.off");
                ItemUnrealEnergyPack.sendStatus(player, "ic2additions.message.jetpackSwitch", TextFormatting.YELLOW, mode);
            }
        }
        if (IC2AdditionsKeys.isHoverKeyDown(player) && toggleTimer == 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)10);
            if (!world.field_72995_K) {
                boolean hover = ItemUnrealEnergyPack.switchHover(stack);
                mode = hover ? TextFormatting.DARK_GREEN + Localization.translate((String)"ic2additions.message.hover_on") : TextFormatting.DARK_RED + Localization.translate((String)"ic2additions.message.hover_off");
                ItemUnrealEnergyPack.sendStatus(player, "ic2additions.message.hoverSwitch", TextFormatting.YELLOW, mode);
            }
        }
        if (toggleTimer > 0) {
            nbt.func_74774_a(TAG_TOGGLE_TIMER, (byte)(toggleTimer - 1));
        }
    }

    private static void sendStatus(EntityPlayer player, String key, TextFormatting color, Object ... args) {
        TextComponentTranslation msg = new TextComponentTranslation(key, args);
        msg.func_150255_a(new Style().func_150238_a(color));
        player.func_145747_a((ITextComponent)msg);
    }

    public boolean isJetpackActive(ItemStack stack) {
        return ItemUnrealEnergyPack.isJetpackOn(stack);
    }

    public double getChargeLevel(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public float getPower(ItemStack stack) {
        return 1.0f;
    }

    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    public float getBaseThrust(ItemStack stack, boolean hover) {
        return hover ? 0.65f : 0.3f;
    }

    public float getBoostThrust(EntityPlayer player, ItemStack stack, boolean hover) {
        return IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.getCharge(stack) >= 60.0 ? (hover ? 0.07f : 0.09f) : 0.0f;
    }

    public boolean useBoostPower(ItemStack stack, float boostAmount) {
        return ElectricItem.manager.discharge(stack, 60.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public float getWorldHeightDivisor(ItemStack stack) {
        return 1.0f;
    }

    public float getHoverMultiplier(ItemStack stack, boolean upwards) {
        return 0.2f;
    }

    public float getHoverBoost(EntityPlayer player, ItemStack stack, boolean up) {
        if (IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.getCharge(stack) >= 60.0) {
            if (!player.field_70122_E) {
                ElectricItem.manager.discharge(stack, 60.0, Integer.MAX_VALUE, true, false, false);
            }
            return 2.0f;
        }
        return 1.0f;
    }

    public boolean drainEnergy(ItemStack pack, int amount) {
        return ElectricItem.manager.discharge(pack, (double)amount * 6.0, Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    @Override
    public int getEnergyPerDamage() {
        return 0;
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.0;
    }
}

